/*
 * Decompiled with CFR 0.152.
 */
package ch.skybeam.mastermind.control;

import ch.skybeam.mastermind.Mastermind;
import ch.skybeam.mastermind.control.GameSettings;
import ch.skybeam.mastermind.model.ComputerPlayer;
import ch.skybeam.mastermind.model.GuessingPlayerInterface;
import ch.skybeam.mastermind.model.Hiscore;
import ch.skybeam.mastermind.model.HiscoreEntry;
import ch.skybeam.mastermind.model.HumanPlayer;
import ch.skybeam.mastermind.model.Matrix;
import ch.skybeam.mastermind.model.MatrixInterface;
import ch.skybeam.mastermind.model.MatrixListenerInterface;
import ch.skybeam.mastermind.model.Pin;
import ch.skybeam.mastermind.model.SettingPlayerInterface;
import ch.skybeam.mastermind.view.GUI;
import ch.skybeam.mastermind.view.GUIListenerInterface;
import ch.skybeam.mastermind.view.OptionChangeEvent;
import ch.skybeam.mastermind.view.PinChangedEvent;
import ch.skybeam.util.Globals;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.AccessControlException;
import javax.naming.CannotProceedException;
import javax.swing.filechooser.FileFilter;

public class Controller
implements GUIListenerInterface,
MatrixListenerInterface {
    private static final String rcsHeader = "$Header: /data/cvs/hta/Mastermind/src/ch/skybeam/mastermind/control/Controller.java,v 1.19 2004/01/29 23:13:36 rme Exp $";
    private static final String rcsName = "$Name: MASTERMIND_RELEASE_20040129 $";
    private static final String rcsRevision = "$Revision: 1.19 $";
    private GameSettings settings = null;
    private String settingsPath = "mastermind.cfg";
    private GuessingPlayerInterface guessingPlayer;
    private SettingPlayerInterface settingPlayer;
    private GUI gui;
    private MatrixInterface matrix;
    private Hiscore hiscore = null;
    private String hiscorePath = "hiscore.dat";
    private boolean isVisible = false;

    public GuessingPlayerInterface getGuessingPlayer() {
        return this.guessingPlayer;
    }

    public SettingPlayerInterface getSettingPlayer() {
        return this.settingPlayer;
    }

    public void hideApplication() {
        this.gui.hide();
        this.isVisible = false;
    }

    public void showApplication() {
        this.gui.show();
        this.isVisible = true;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public Controller() {
        if (!Mastermind.isApplet()) {
            ObjectInputStream objectInputStream;
            FileInputStream fileInputStream;
            try {
                fileInputStream = new FileInputStream(this.settingsPath);
                objectInputStream = new ObjectInputStream(fileInputStream);
                this.settings = (GameSettings)objectInputStream.readObject();
                objectInputStream.close();
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println(this.getClass() + ": Fehler beim Lesen der Einstallungen: " + classNotFoundException);
            }
            catch (IOException iOException) {
                System.out.println("Keine Einstellungen gefunden, starte mit Standardeinstellungen.");
            }
            catch (AccessControlException accessControlException) {
                System.out.println("Keinen Zugriff auf die Einstellungsdatei (" + this.settingsPath + "): " + accessControlException);
            }
            catch (SecurityException securityException) {
                System.out.println("Keinen Zugriff auf die Einstellungsdatei sec (" + this.settingsPath + "): " + securityException);
            }
            try {
                fileInputStream = new FileInputStream(this.hiscorePath);
                objectInputStream = new ObjectInputStream(fileInputStream);
                this.hiscore = (Hiscore)objectInputStream.readObject();
                objectInputStream.close();
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println(this.getClass() + ": Fehler beim Lesen der Highscores: " + classNotFoundException);
            }
            catch (IOException iOException) {
                System.out.println("Keine Higscores gefunden, starte mit leerer Highscore.");
            }
            catch (SecurityException securityException) {
                System.out.println("Keinen Zugriff auf die Einstellungsdatei (" + this.settingsPath + "): " + securityException);
            }
        }
        if (this.settings == null) {
            if (Globals.getDebugLevel() > 0) {
                System.out.println(this.getClass() + ": creating new settings");
            }
            this.settings = new GameSettings();
        }
        if (this.hiscore == null) {
            this.hiscore = new Hiscore();
        }
        this.settingPlayer = new ComputerPlayer();
        this.guessingPlayer = new HumanPlayer(this.settings.getPlayerName());
        this.matrix = this.newMatrix();
        this.gui = this.newGUI(this.matrix);
        this.showApplication();
        this.gui.showSplash(5000);
    }

    public void aboutAction() {
        this.gui.showAbout();
    }

    public void giveUpAction() {
        if (!this.matrix.isStarted()) {
            this.gui.notifyUser("Sie sollten zuerst anfangen zu spielen bevor sie aufgeben! :-)");
        } else if (this.matrix.isFinished()) {
            int n = this.gui.yesNoDialog("Das aktuelle Spiel ist beendet. M\u00f6chten Sie ein neues starten?");
            if (n == 1) {
                this.newGameAction();
            }
        } else {
            int n = this.gui.yesNoDialog("M\u00f6chten sie das aktuelle Spiel wirklich aufgeben?");
            if (n == 1) {
                try {
                    this.matrix.giveUp();
                }
                catch (CannotProceedException cannotProceedException) {
                    this.gui.notifyUser(cannotProceedException.getMessage());
                }
            }
        }
    }

    public void helpAction() {
        this.gui.showHelp();
    }

    public void loadGameAction() {
        FileFilter[] fileFilterArray = new FileFilter[]{new FileExtensionFilter(".sav")};
        File file = this.gui.getFile(fileFilterArray);
    }

    public void newGameAction() {
        boolean bl = true;
        if (!this.matrix.isFinished() && this.matrix.isStarted()) {
            int n = this.gui.yesNoDialog("M\u00f6chten Sie wirklich ein neues spiel beginnen und das aktuelle Spiel verwerfen?");
            bl = n == 1;
        }
        if (bl) {
            this.settingPlayer = new ComputerPlayer();
            this.guessingPlayer = new HumanPlayer(this.guessingPlayer.getName());
            this.matrix = this.newMatrix();
            this.gui.setPinVariation(this.settings.getPinVariation());
            this.gui.newGame(this.matrix);
        }
    }

    private MatrixInterface newMatrix() {
        try {
            Pin[] pinArray = this.settingPlayer.getNewGuessWord(this.settings.getNumberOfColumns(), this.settings.getNumberOfPinTypes(), this.settings.isMultiColorMode());
            this.matrix = new Matrix(this.settings.getNumberOfColumns(), this.settings.getNumberOfRows(), pinArray, this.settings.isMultiColorMode(), this.settings.isCorrectionOrder(), this.settings.getNumberOfPinTypes());
        }
        catch (Exception exception) {
            this.gui.errorDialog(exception);
        }
        this.matrix.addMatrixListener(this);
        return this.matrix;
    }

    private GUI newGUI(MatrixInterface matrixInterface) {
        GUI gUI = new GUI(matrixInterface, this.guessingPlayer);
        gUI.setPinVariation(this.settings.getPinVariation());
        gUI.addAboutListener(this);
        gUI.addGiveUpListener(this);
        gUI.addHelpListener(this);
        gUI.addLoadGameListener(this);
        gUI.addNameListener(this);
        gUI.addNewGameListener(this);
        gUI.addOptionListener(this);
        gUI.addPinChangeListener(this);
        gUI.addQuitListener(this);
        gUI.addRevealListener(this);
        gUI.addSaveGameListener(this);
        gUI.addShowHighscoreListener(this);
        return gUI;
    }

    public void optionsChangedAction(OptionChangeEvent optionChangeEvent) {
        int n;
        this.settings.setPlayerName(optionChangeEvent.getPlayerName());
        this.guessingPlayer.setName(optionChangeEvent.getPlayerName());
        this.gui.setGuessingPlayer(this.guessingPlayer);
        boolean bl = false;
        if ((optionChangeEvent.getCorrectionOrder() != this.matrix.getCorrectionOrder() || optionChangeEvent.getMultiColorMode() != this.matrix.getMultiColorMode() || optionChangeEvent.getNumberOfPinTypes() != this.matrix.getNumberOfPinTypes() || optionChangeEvent.getNumberOfColumns() != this.matrix.getSizeX() || optionChangeEvent.getNumberOfRows() != this.matrix.getSizeY() || optionChangeEvent.getPinVariation() != this.settings.getPinVariation()) && (n = this.gui.yesNoDialog("Sie Haben Optionen ver\u00e4ndert die einen neustart des Spiels bedingen.\nM\u00f6chten Sie jetzt ein neues Spiel beginnen?")) == 1) {
            this.settings.setCorrectionOrder(optionChangeEvent.getCorrectionOrder());
            this.settings.setMultiColorMode(optionChangeEvent.getMultiColorMode());
            this.settings.setNumberOfPinTypes(optionChangeEvent.getNumberOfPinTypes());
            this.settings.setNumberOfColumns(optionChangeEvent.getNumberOfColumns());
            this.settings.setNumberOfRows(optionChangeEvent.getNumberOfRows());
            this.settings.setPinVariation(optionChangeEvent.getPinVariation());
            this.newGameAction();
        }
    }

    public void optionsAction() {
        this.gui.options();
    }

    public void pinChangedAction(PinChangedEvent pinChangedEvent) {
        try {
            this.matrix.setPin(pinChangedEvent.getPin(), pinChangedEvent.getX(), pinChangedEvent.getY());
        }
        catch (CannotProceedException cannotProceedException) {
            this.gui.notifyUser(cannotProceedException.getMessage());
        }
        catch (Exception exception) {
            this.gui.errorDialog(exception);
        }
    }

    public void quitAction() {
        if (this.gui.yesNoDialog("Das wollen Sie nicht wirklich tun - oder doch?") == 1) {
            if (!Mastermind.isApplet()) {
                try {
                    ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(this.hiscorePath));
                    objectOutputStream.writeObject(this.hiscore);
                    objectOutputStream.close();
                    ObjectOutputStream objectOutputStream2 = new ObjectOutputStream(new FileOutputStream(this.settingsPath));
                    objectOutputStream2.writeObject(this.settings);
                    objectOutputStream2.close();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.gui.notifyUser("Einstellungen / Hiscores konnten nicht gespeichert werden. Bitte pr\u00fcfen sie, ob im Arbeitsverzeichnis ausreichende Rechte zur Verf\u00fcgung stehen.");
                }
                catch (IOException iOException) {
                    this.gui.errorDialog(iOException);
                }
                System.exit(0);
            } else {
                this.hideApplication();
            }
        } else {
            this.gui.notifyUser("Wusste ich's doch :-)");
        }
    }

    public void revealAction() {
        try {
            this.matrix.reveal();
        }
        catch (CannotProceedException cannotProceedException) {
            this.gui.notifyUser(cannotProceedException.getMessage());
        }
    }

    public void saveGameAction() {
        FileFilter[] fileFilterArray = new FileFilter[]{new FileExtensionFilter(".sav")};
        File file = this.gui.getFile(fileFilterArray);
    }

    public void showHighscoreAction() {
        if (Mastermind.isApplet()) {
            this.gui.notifyUser("Hinweis: Die Highscores k\u00f6nnen leider in der Applet-Version nicht gespeichert werden, deshalb gehen die Eintr\u00e4ge beim Beenden verloren.");
        }
        this.gui.showHiscores(this.hiscore);
    }

    public void solvedAction(Pin[] pinArray, long l) {
        this.gui.solved(pinArray, l);
        String string = this.gui.getTextFromUser("Sie haben's geschafft! Bitte geben Sie ihren Namen ein.", this.guessingPlayer.getName());
        this.guessingPlayer.setName(string);
        this.settings.setPlayerName(string);
        this.gui.setGuessingPlayer(this.guessingPlayer);
        HiscoreEntry hiscoreEntry = new HiscoreEntry(this.matrix.getNumberOfPinTypes(), this.matrix.getCurrentRow(), this.guessingPlayer.getName(), this.matrix.getMultiColorMode(), this.matrix.getCorrectionOrder(), this.matrix.getSizeY(), this.matrix.getSizeX(), l);
        this.hiscore.addHiscore(hiscoreEntry);
    }

    public void matrixChangedAction(Matrix matrix) {
        this.gui.setMatrix(matrix);
    }

    public void giveUpAction(Pin[] pinArray, long l) {
        this.gui.giveUp(pinArray, l);
    }

    public void gameLostAction(Pin[] pinArray, long l) {
        this.gui.gameLost(pinArray, l);
    }

    private class FileExtensionFilter
    extends FileFilter {
        String extension;

        public FileExtensionFilter(String string) {
            this.extension = string;
        }

        public boolean accept(File file) {
            boolean bl = false;
            if (file.isFile()) {
                String string = file.getName();
                if (string.endsWith(this.extension)) {
                    bl = true;
                }
            } else if (file.isDirectory()) {
                bl = true;
            }
            return bl;
        }

        public String getDescription() {
            return ".sav - Savegames";
        }
    }
}

