/*
 * Decompiled with CFR 0.152.
 */
package ch.skybeam.mastermind.model;

import ch.skybeam.mastermind.model.MatrixInterface;
import ch.skybeam.mastermind.model.MatrixListenerInterface;
import ch.skybeam.mastermind.model.Pin;
import ch.skybeam.util.StopWatch;
import java.util.Enumeration;
import java.util.Vector;
import javax.naming.CannotProceedException;

public class Matrix
implements MatrixInterface {
    private static final String rcsHeader = "$Header: /data/cvs/hta/Mastermind/src/ch/skybeam/mastermind/model/Matrix.java,v 1.30 2004/01/29 23:04:18 rme Exp $";
    private static final String rcsName = "$Name: MASTERMIND_RELEASE_20040129 $";
    private static final String rcsRevision = "$Revision: 1.30 $";
    private boolean gameFinished = false;
    private boolean gameStarted = false;
    private StopWatch stopWatch;
    private boolean correctionOrder = true;
    private int currentRow = 1;
    private Pin[] guessWord;
    private boolean multiColorMode = true;
    private int numberOfPinTypes = 6;
    private Pin[][] pinMatrix;
    private int sizeX = 8;
    private int sizeY = 4;
    private Vector matrixListeners = new Vector();

    private void fireMatrixChangedEvent() {
        Enumeration enumeration = this.matrixListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((MatrixListenerInterface)enumeration.nextElement()).matrixChangedAction(this);
        }
    }

    private void fireSolvedEvent() {
        this.gameFinished = true;
        Enumeration enumeration = this.matrixListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((MatrixListenerInterface)enumeration.nextElement()).solvedAction(this.guessWord, this.stopWatch.getTime());
        }
    }

    private void fireGiveUpAction() {
        this.gameFinished = true;
        Enumeration enumeration = this.matrixListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((MatrixListenerInterface)enumeration.nextElement()).giveUpAction(this.guessWord, this.stopWatch.getTime());
        }
    }

    private void fireGameLostAction() {
        this.gameFinished = true;
        Enumeration enumeration = this.matrixListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((MatrixListenerInterface)enumeration.nextElement()).gameLostAction(this.guessWord, this.stopWatch.getTime());
        }
    }

    public Matrix(int n, int n2, Pin[] pinArray, boolean bl, boolean bl2, int n3) throws Exception {
        if (pinArray.length == n) {
            int n4;
            for (n4 = 0; n4 < pinArray.length; ++n4) {
                if (pinArray[n4] != null) continue;
                throw new Exception("null references in guessword");
            }
            if (!this.multiColorMode) {
                n4 = 1;
                for (int i = 0; i < pinArray.length && n4 != 0; ++i) {
                    for (int j = i + 1; j < pinArray.length && n4 != 0; ++j) {
                        if (pinArray[i] != pinArray[j]) continue;
                        n4 = 0;
                    }
                }
                if (n4 == 0) {
                    throw new Exception("invalid guessword (duplicated entries in non-multi color mode)");
                }
            }
        } else {
            throw new Exception("wrong guessword length");
        }
        this.sizeX = n;
        this.sizeY = n2;
        this.guessWord = pinArray;
        this.multiColorMode = bl;
        this.correctionOrder = bl2;
        this.numberOfPinTypes = n3;
        this.pinMatrix = new Pin[n][n2];
        this.stopWatch = new StopWatch();
    }

    public void addMatrixListener(MatrixListenerInterface matrixListenerInterface) {
        this.matrixListeners.add(matrixListenerInterface);
    }

    public boolean getCorrectionOrder() {
        return this.correctionOrder;
    }

    public int getCorrectPins(int n) {
        int n2 = 0;
        if (n < this.currentRow) {
            for (int i = 0; i < this.getSizeX(); ++i) {
                if (this.pinMatrix[i][n - 1] == null || this.pinMatrix[i][n - 1].getStatus() != 3) continue;
                ++n2;
            }
        }
        return n2;
    }

    public int getWrongPositionPins(int n) {
        int n2 = 0;
        if (n < this.currentRow) {
            for (int i = 0; i < this.getSizeX(); ++i) {
                if (this.pinMatrix[i][n - 1] == null || this.pinMatrix[i][n - 1].getStatus() != 2) continue;
                ++n2;
            }
        }
        return n2;
    }

    public int getCurrentRow() {
        int n = this.currentRow;
        if (this.gameFinished) {
            n = this.currentRow - 1;
        }
        return n;
    }

    public boolean getMultiColorMode() {
        return this.multiColorMode;
    }

    public int getNumberOfPinTypes() {
        return this.numberOfPinTypes;
    }

    public Pin getPin(int n, int n2) {
        if (n > 0 && n2 > 0 && n <= this.getSizeX() && n2 <= this.getSizeY()) {
            return this.pinMatrix[n - 1][n2 - 1];
        }
        return null;
    }

    public Pin[][] getPinMatrix() {
        return this.pinMatrix;
    }

    public int getSizeX() {
        return this.sizeX;
    }

    public int getSizeY() {
        return this.sizeY;
    }

    public void removeMatrixListener(MatrixListenerInterface matrixListenerInterface) {
        this.matrixListeners.remove(matrixListenerInterface);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void reveal() throws CannotProceedException {
        Pin pin;
        int n;
        int n2;
        if (this.gameFinished) throw new CannotProceedException("Das Spiel ist bereits beendet!");
        boolean bl = true;
        for (n2 = 0; n2 < this.sizeX; ++n2) {
            if (this.pinMatrix[n2][this.currentRow - 1] != null) continue;
            bl = false;
        }
        n2 = 0;
        if (!bl) throw new CannotProceedException("Sie haben versucht eine unvollst\u00e4ndige Reihe auszuwerten. Bitte vervollst\u00e4ndigen Sie zuerst die Reihe!");
        Pin[] pinArray = new Pin[this.guessWord.length];
        for (n = 0; n < this.guessWord.length; ++n) {
            pinArray[n] = new Pin(this.guessWord[n].getType());
        }
        for (n = 0; n < this.getSizeX(); ++n) {
            pin = this.pinMatrix[n][this.currentRow - 1];
            if (pin.getType() != pinArray[n].getType()) continue;
            pin.setStatus(3);
            ++n2;
            pinArray[n] = null;
        }
        for (n = 0; n < this.getSizeX(); ++n) {
            pin = this.pinMatrix[n][this.currentRow - 1];
            if (pin.getStatus() == 3) continue;
            for (int i = 0; i < this.getSizeX() && pin.getStatus() != 2; ++i) {
                if (pinArray[i] == null || pin.getType() != pinArray[i].getType()) continue;
                pin.setStatus(2);
                pinArray[i] = null;
            }
        }
        for (n = 0; n < this.getSizeX(); ++n) {
            if (this.pinMatrix[n][this.currentRow - 1].getStatus() != 0) continue;
            this.pinMatrix[n][this.currentRow - 1].setStatus(1);
        }
        if (n2 == this.getSizeX()) {
            ++this.currentRow;
            this.fireMatrixChangedEvent();
            this.fireSolvedEvent();
            return;
        } else {
            ++this.currentRow;
            this.fireMatrixChangedEvent();
            if (this.getCurrentRow() <= this.getSizeY()) return;
            this.fireGameLostAction();
        }
    }

    public void setPin(Pin pin, int n, int n2) throws CannotProceedException {
        if (!this.gameStarted) {
            this.gameStarted = true;
            this.stopWatch.setStart();
        }
        if (!this.gameFinished) {
            if (n2 >= this.currentRow) {
                if (!this.multiColorMode) {
                    for (int i = 0; i < this.getSizeX(); ++i) {
                        if (this.pinMatrix[i][n2 - 1] == null || this.pinMatrix[i][n2 - 1].getType() != pin.getType()) continue;
                        this.pinMatrix[i][n2 - 1] = null;
                    }
                }
                this.pinMatrix[n - 1][n2 - 1] = new Pin(pin.getType());
                this.fireMatrixChangedEvent();
            }
        } else {
            throw new CannotProceedException("Das Spiel ist bereits beendet! - Setzen eines Pins bei beendetem Spiel nicht mehr m\u00f6glich!");
        }
    }

    public void giveUp() throws CannotProceedException {
        if (this.gameFinished) {
            throw new CannotProceedException("Das Spiel ist bereits beendet! - Setzen eines Pins bei beendetem Spiel nicht mehr m\u00f6glich!");
        }
        this.fireGiveUpAction();
    }

    public boolean isFinished() {
        return this.gameFinished;
    }

    public boolean isStarted() {
        return this.gameStarted;
    }
}

