/*
 * Decompiled with CFR 0.152.
 */
package ch.skybeam.mastermind.view;

import ch.skybeam.mastermind.view.PinVariationInterface;
import java.awt.Color;
import java.awt.Graphics;

public class ColorVariation
implements PinVariationInterface {
    private static final String rcsHeader = "$Header: /data/cvs/hta/Mastermind/src/ch/skybeam/mastermind/view/ColorVariation.java,v 1.1 2004/01/17 19:37:13 rme Exp $";
    private static final String rcsName = "$Name: MASTERMIND_RELEASE_20040129 $";
    private static final String rcsRevision = "$Revision: 1.1 $";
    private Color[] colors = new Color[]{Color.GREEN, Color.RED, Color.BLUE, Color.BLACK, Color.MAGENTA, Color.ORANGE, Color.WHITE, Color.YELLOW};
    private int pinWidth = 20;
    private int pinHeight = 20;

    public void drawPin(int n, Graphics graphics, int n2, int n3) throws IllegalArgumentException {
        if (n > this.getNumberOfTypes() || n <= 0) {
            throw new IllegalPinTypeException(n);
        }
        Color color = graphics.getColor();
        graphics.setColor(this.colors[n - 1]);
        graphics.fillOval((int)((double)n2 - (double)this.pinWidth / 2.0), (int)((double)n3 - (double)this.pinWidth / 2.0), this.pinWidth, this.pinHeight);
        graphics.setColor(color);
    }

    public String getDescription() {
        return "Plain color Pins";
    }

    public int getNumberOfTypes() {
        return this.colors.length;
    }

    private class IllegalPinTypeException
    extends IllegalArgumentException {
        public IllegalPinTypeException(int n) {
            super("Pin type (" + n + ")" + " out of range.\nAllowed range: 0 < pinType < " + ColorVariation.this.getNumberOfTypes());
        }

        public IllegalPinTypeException(String string) {
            super(string);
        }
    }
}

