/*
 * Decompiled with CFR 0.152.
 */
package ch.skybeam.mastermind.view;

import ch.skybeam.mastermind.model.GuessingPlayerInterface;
import ch.skybeam.mastermind.model.Hiscore;
import ch.skybeam.mastermind.model.HiscoreEntry;
import ch.skybeam.mastermind.model.MatrixInterface;
import ch.skybeam.mastermind.model.Pin;
import ch.skybeam.mastermind.view.GUIInterface;
import ch.skybeam.mastermind.view.GUIListenerInterface;
import ch.skybeam.mastermind.view.HangmanPanel;
import ch.skybeam.mastermind.view.OptionChangeEvent;
import ch.skybeam.mastermind.view.PinChangedEvent;
import ch.skybeam.mastermind.view.PinMatrix;
import ch.skybeam.mastermind.view.PinMatrixListener;
import ch.skybeam.mastermind.view.PinTypeConverter;
import ch.skybeam.mastermind.view.SelectorPanel;
import ch.skybeam.mastermind.view.SelectorPanelListenerInterface;
import ch.skybeam.util.Globals;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.URL;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.naming.directory.InvalidAttributeValueException;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.JWindow;
import javax.swing.SpinnerNumberModel;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableModel;

public class GUI
extends JFrame
implements GUIInterface,
PinMatrixListener,
SelectorPanelListenerInterface {
    private static final String rcsHeader = "$Header: /data/cvs/hta/Mastermind/src/ch/skybeam/mastermind/view/GUI.java,v 1.23 2004/01/29 23:14:45 rme Exp $";
    private static final String rcsName = "$Name: MASTERMIND_RELEASE_20040129 $";
    private static final String rcsRevision = "$Revision: 1.23 $";
    private Vector aboutListeners = new Vector();
    private Vector giveUpListeners = new Vector();
    private Vector helpListeners = new Vector();
    private Vector loadGameListeners = new Vector();
    private Vector newGameListeners = new Vector();
    private Vector nameListeners = new Vector();
    private Vector optionListeners = new Vector();
    private Vector optionChangeListeners = new Vector();
    private Vector pinChangeListeners = new Vector();
    private Vector quitListeners = new Vector();
    private Vector revealListeners = new Vector();
    private Vector saveGameListeners = new Vector();
    private Vector showHighscoreListeners = new Vector();
    private Hiscore hiscore;
    private HiscoreEntry hiscoreEntry;
    private ObjectInputStream in;
    private int pinVariation = 1;
    private PinTypeConverter converter;
    private JMenuBar menuBar = new JMenuBar();
    private GuessingPlayerInterface guessingPlayer;
    private MatrixInterface matrix;
    private JTextField nameTextField;
    private PinMatrix matrixPanel;
    private JPanel solverPanel;
    private HangmanPanel hangmanPanel;
    private boolean hangman = true;
    private SelectorPanel selectorPanel;
    private JButton revealButton;
    private JButton newGameButton;
    private JButton giveUpButton;
    private JMenuItem highscoreMenuItem;
    private JMenuItem quitMenuItem;
    private JMenuItem revealMenuItem;
    private JMenuItem newGameMenuItem;
    private JMenuItem giveUpMenuItem;
    private JMenuItem optionsMenuItem;
    private JMenuItem helpMenuItem;
    private JMenuItem aboutMenuItem;
    private Pin currentPin = null;
    static /* synthetic */ Class class$ch$skybeam$mastermind$Mastermind;
    static /* synthetic */ Class class$java$lang$String;

    public GUI(MatrixInterface matrixInterface, GuessingPlayerInterface guessingPlayerInterface) {
        this.guessingPlayer = guessingPlayerInterface;
        this.matrix = matrixInterface;
        this.converter = new PinTypeConverter();
        this.setTitle("Mastermind");
        this.setSize(750, 700);
        this.setResizable(true);
        this.setLocation(50, 10);
        this.setupMenuBar();
        this.setupContentPane();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                GUI.this.fireQuitEvent();
            }
        });
        this.getContentPane().addMouseWheelListener(new GUIMouseWheelListener());
    }

    private void setupMenuBar() {
        JMenu jMenu = new JMenu("Datei");
        this.highscoreMenuItem = new JMenuItem("Highscore");
        this.highscoreMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GUI.this.fireShowHighscoreEvent();
            }
        });
        this.quitMenuItem = new JMenuItem("Beenden");
        this.quitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GUI.this.fireQuitEvent();
            }
        });
        jMenu.add(this.highscoreMenuItem);
        jMenu.addSeparator();
        jMenu.add(this.quitMenuItem);
        JMenu jMenu2 = new JMenu("Spiel");
        this.newGameMenuItem = new JMenuItem("Neues Spiel");
        this.newGameMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GUI.this.fireNewGameEvent();
            }
        });
        this.revealMenuItem = new JMenuItem("Auswerten");
        this.revealMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GUI.this.fireRevealEvent();
            }
        });
        this.giveUpMenuItem = new JMenuItem("Aufgeben");
        this.giveUpMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GUI.this.fireGiveUpEvent();
            }
        });
        this.optionsMenuItem = new JMenuItem("Optionen");
        this.optionsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GUI.this.fireOptionsEvent();
            }
        });
        jMenu2.add(this.revealMenuItem);
        jMenu2.addSeparator();
        jMenu2.add(this.newGameMenuItem);
        jMenu2.addSeparator();
        jMenu2.add(this.giveUpMenuItem);
        jMenu2.addSeparator();
        jMenu2.add(this.optionsMenuItem);
        JMenu jMenu3 = new JMenu("Hilfe");
        this.helpMenuItem = new JMenuItem("Hilfe");
        this.helpMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GUI.this.fireHelpEvent();
            }
        });
        this.aboutMenuItem = new JMenuItem("\u00dcber Mastermind");
        this.aboutMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GUI.this.fireAboutEvent();
            }
        });
        jMenu3.add(this.helpMenuItem);
        jMenu3.addSeparator();
        jMenu3.add(this.aboutMenuItem);
        this.menuBar.add(jMenu);
        this.menuBar.add(jMenu2);
        this.menuBar.add(jMenu3);
        this.setJMenuBar(this.menuBar);
    }

    private void setupContentPane() {
        GridBagConstraints gridBagConstraints;
        Object object;
        this.getContentPane().removeAll();
        this.getContentPane().setBackground(Color.WHITE);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.getContentPane().setLayout(gridBagLayout);
        this.nameTextField = new JTextField(this.guessingPlayer.getName());
        this.nameTextField.setEnabled(false);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridwidth = 2;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.fill = 2;
        gridBagLayout.addLayoutComponent(this.nameTextField, gridBagConstraints2);
        this.getContentPane().add(this.nameTextField);
        this.matrixPanel = new PinMatrix(this.matrix, this.matrix.getCorrectionOrder(), this.converter);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 1;
        gridBagConstraints3.gridwidth = 2;
        gridBagConstraints3.gridheight = 11;
        gridBagConstraints3.weightx = 20.0;
        gridBagConstraints3.weighty = 10.0;
        gridBagConstraints3.fill = 1;
        gridBagLayout.addLayoutComponent(this.matrixPanel, gridBagConstraints3);
        this.matrixPanel.addMatrixChangeListener(this);
        this.getContentPane().add(this.matrixPanel);
        if (this.hangman) {
            try {
                this.hangmanPanel = new HangmanPanel(this.matrix.getSizeY());
                object = new Thread(this.hangmanPanel);
                ((Thread)object).start();
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 2;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.gridheight = 7;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 7.0;
                gridBagConstraints.fill = 1;
                gridBagLayout.addLayoutComponent(this.hangmanPanel, gridBagConstraints);
                this.getContentPane().add(this.hangmanPanel);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.errorDialog(fileNotFoundException);
            }
        }
        object = new JPanel(new FlowLayout());
        ((JComponent)object).setBackground(Color.WHITE);
        this.revealButton = new JButton("auswerten");
        this.revealButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GUI.this.fireRevealEvent();
            }
        });
        ((Container)object).add(this.revealButton);
        this.newGameButton = new JButton("neues Spiel");
        this.newGameButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GUI.this.fireNewGameEvent();
            }
        });
        ((Container)object).add(this.newGameButton);
        this.giveUpButton = new JButton("aufgeben");
        this.giveUpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GUI.this.fireGiveUpEvent();
            }
        });
        ((Container)object).add(this.giveUpButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.addLayoutComponent((Component)object, gridBagConstraints);
        this.getContentPane().add((Component)object);
        try {
            this.selectorPanel = new SelectorPanel(this.matrix.getNumberOfPinTypes(), this.converter);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.errorDialog(illegalArgumentException);
        }
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 2;
        gridBagConstraints4.gridy = 9;
        gridBagConstraints4.gridwidth = 1;
        gridBagConstraints4.gridheight = 2;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.weighty = 2.0;
        gridBagConstraints4.fill = 1;
        gridBagLayout.addLayoutComponent(this.selectorPanel, gridBagConstraints4);
        this.selectorPanel.addPinClickListeners(this);
        this.getContentPane().add(this.selectorPanel);
        this.getContentPane().paintAll(this.getContentPane().getGraphics());
    }

    private void fireAboutEvent() {
        Enumeration enumeration = this.aboutListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((GUIListenerInterface)enumeration.nextElement()).aboutAction();
        }
    }

    private void fireGiveUpEvent() {
        Enumeration enumeration = this.giveUpListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((GUIListenerInterface)enumeration.nextElement()).giveUpAction();
        }
    }

    private void fireHelpEvent() {
        Enumeration enumeration = this.helpListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((GUIListenerInterface)enumeration.nextElement()).helpAction();
        }
    }

    private void fireLoadGameEvent() {
        Enumeration enumeration = this.loadGameListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((GUIListenerInterface)enumeration.nextElement()).loadGameAction();
        }
    }

    private void fireNewGameEvent() {
        Enumeration enumeration = this.newGameListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((GUIListenerInterface)enumeration.nextElement()).newGameAction();
        }
    }

    private void fireOptionsEvent() {
        Enumeration enumeration = this.optionListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((GUIListenerInterface)enumeration.nextElement()).optionsAction();
        }
    }

    private void fireOptionsEvent(OptionChangeEvent optionChangeEvent) {
        Enumeration enumeration = this.optionListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((GUIListenerInterface)enumeration.nextElement()).optionsChangedAction(optionChangeEvent);
        }
    }

    private void firePinChangeEvent(PinChangedEvent pinChangedEvent) {
        Enumeration enumeration = this.pinChangeListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((GUIListenerInterface)enumeration.nextElement()).pinChangedAction(pinChangedEvent);
        }
    }

    private void fireQuitEvent() {
        Enumeration enumeration = this.quitListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((GUIListenerInterface)enumeration.nextElement()).quitAction();
        }
    }

    private void fireRevealEvent() {
        Enumeration enumeration = this.revealListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((GUIListenerInterface)enumeration.nextElement()).revealAction();
        }
    }

    private void fireSaveGameEvent() {
        Enumeration enumeration = this.saveGameListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((GUIListenerInterface)enumeration.nextElement()).saveGameAction();
        }
    }

    private void fireShowHighscoreEvent() {
        Enumeration enumeration = this.showHighscoreListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((GUIListenerInterface)enumeration.nextElement()).showHighscoreAction();
        }
    }

    public boolean addAboutListener(GUIListenerInterface gUIListenerInterface) {
        return this.aboutListeners.add(gUIListenerInterface);
    }

    public boolean addGiveUpListener(GUIListenerInterface gUIListenerInterface) {
        return this.giveUpListeners.add(gUIListenerInterface);
    }

    public boolean addHelpListener(GUIListenerInterface gUIListenerInterface) {
        return this.helpListeners.add(gUIListenerInterface);
    }

    public boolean addLoadGameListener(GUIListenerInterface gUIListenerInterface) {
        return this.loadGameListeners.add(gUIListenerInterface);
    }

    public boolean addNameListener(GUIListenerInterface gUIListenerInterface) {
        return this.nameListeners.add(gUIListenerInterface);
    }

    public boolean addNewGameListener(GUIListenerInterface gUIListenerInterface) {
        return this.newGameListeners.add(gUIListenerInterface);
    }

    public boolean addOptionListener(GUIListenerInterface gUIListenerInterface) {
        return this.optionListeners.add(gUIListenerInterface);
    }

    public boolean addOptionChangeListener(GUIListenerInterface gUIListenerInterface) {
        return this.optionChangeListeners.add(gUIListenerInterface);
    }

    public boolean addPinChangeListener(GUIListenerInterface gUIListenerInterface) {
        return this.pinChangeListeners.add(gUIListenerInterface);
    }

    public boolean addQuitListener(GUIListenerInterface gUIListenerInterface) {
        return this.quitListeners.add(gUIListenerInterface);
    }

    public boolean addRevealListener(GUIListenerInterface gUIListenerInterface) {
        return this.revealListeners.add(gUIListenerInterface);
    }

    public boolean addSaveGameListener(GUIListenerInterface gUIListenerInterface) {
        return this.saveGameListeners.add(gUIListenerInterface);
    }

    public boolean addShowHighscoreListener(GUIListenerInterface gUIListenerInterface) {
        return this.showHighscoreListeners.add(gUIListenerInterface);
    }

    public File getFile(FileFilter[] fileFilterArray) {
        int n;
        JFileChooser jFileChooser = new JFileChooser();
        if (fileFilterArray != null) {
            for (n = 0; n < fileFilterArray.length; ++n) {
                jFileChooser.setFileFilter(fileFilterArray[n]);
            }
        }
        if ((n = jFileChooser.showDialog(this, "Select File")) == 0) {
            return jFileChooser.getSelectedFile();
        }
        return null;
    }

    public void options() {
        OptionsDialog optionsDialog = new OptionsDialog(this);
        optionsDialog.setLocationRelativeTo(this);
        optionsDialog.show();
    }

    public boolean removeAboutListener(GUIListenerInterface gUIListenerInterface) {
        return this.aboutListeners.remove(gUIListenerInterface);
    }

    public boolean removeGiveUpListener(GUIListenerInterface gUIListenerInterface) {
        return this.giveUpListeners.remove(gUIListenerInterface);
    }

    public boolean removeHelpListener(GUIListenerInterface gUIListenerInterface) {
        return this.helpListeners.remove(gUIListenerInterface);
    }

    public boolean removeLoadGameListener(GUIListenerInterface gUIListenerInterface) {
        return this.loadGameListeners.remove(gUIListenerInterface);
    }

    public boolean removeNameListener(GUIListenerInterface gUIListenerInterface) {
        return this.nameListeners.remove(gUIListenerInterface);
    }

    public boolean removeNewGameListener(GUIListenerInterface gUIListenerInterface) {
        return this.newGameListeners.remove(gUIListenerInterface);
    }

    public boolean removeOptionListener(GUIListenerInterface gUIListenerInterface) {
        return this.optionListeners.remove(gUIListenerInterface);
    }

    public boolean removeOptionChangeListener(GUIListenerInterface gUIListenerInterface) {
        return this.optionChangeListeners.remove(gUIListenerInterface);
    }

    public boolean removePinChangeListener(GUIListenerInterface gUIListenerInterface) {
        return this.pinChangeListeners.remove(gUIListenerInterface);
    }

    public boolean removeQuitListener(GUIListenerInterface gUIListenerInterface) {
        return this.quitListeners.remove(gUIListenerInterface);
    }

    public boolean removeRevealListener(GUIListenerInterface gUIListenerInterface) {
        return this.revealListeners.remove(gUIListenerInterface);
    }

    public boolean removeSaveGameListener(GUIListenerInterface gUIListenerInterface) {
        return this.saveGameListeners.remove(gUIListenerInterface);
    }

    public boolean removeShowHighscoreListener(GUIListenerInterface gUIListenerInterface) {
        return this.showHighscoreListeners.remove(gUIListenerInterface);
    }

    public void showAbout() {
        AboutDialog aboutDialog = new AboutDialog(this);
        aboutDialog.setLocationRelativeTo(this);
        aboutDialog.show();
    }

    public void showHelp() {
        HelpDialog helpDialog = new HelpDialog(this);
        helpDialog.setLocationRelativeTo(this);
        helpDialog.show();
    }

    public void showHiscores(Hiscore hiscore) {
        if (hiscore != null) {
            HiscoreDialog hiscoreDialog = new HiscoreDialog(this, hiscore);
            hiscoreDialog.setLocationRelativeTo(this);
            hiscoreDialog.show();
        } else {
            this.notifyUser("Leider keine Hiscores verf\u00fcgbar!");
        }
    }

    public void solved(Pin[] pinArray, long l) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(l);
        this.matrixPanel.solved(pinArray);
        this.notifyUser("Gratuliere, du hast das R\u00e4tsel in " + this.matrix.getCurrentRow() + " Z\u00fcgen gel\u00f6sst!\n" + "Daf\u00fcr hast du auch nur " + calendar.get(12) + " Minuten und " + calendar.get(13) + " Sekunden gebraucht.");
    }

    public int yesNoDialog(String string) {
        YesNoDialog yesNoDialog = new YesNoDialog(this, string);
        yesNoDialog.setLocationRelativeTo(this);
        yesNoDialog.show();
        return yesNoDialog.getAnswer();
    }

    public int getPinVariation() {
        return this.pinVariation;
    }

    public void setPinVariation(int n) {
        this.pinVariation = n;
        try {
            this.converter.setVariation(n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.errorDialog(illegalArgumentException);
        }
        this.selectorPanel.setPinVariation(this.converter);
        this.matrixPanel.setPinVariation(this.converter);
        this.getContentPane().repaint();
    }

    public void pinMatrixChanged(PinChangedEvent pinChangedEvent) {
        this.firePinChangeEvent(pinChangedEvent);
    }

    public void setMatrix(MatrixInterface matrixInterface) {
        this.matrix = matrixInterface;
        this.matrixPanel.setNewMatrix(matrixInterface);
        this.selectorPanel.setNumberOfPinTypes(matrixInterface.getNumberOfPinTypes());
        try {
            this.hangmanPanel.setStep(matrixInterface.getCurrentRow() - 1);
        }
        catch (InvalidAttributeValueException invalidAttributeValueException) {
            this.errorDialog(invalidAttributeValueException);
        }
    }

    public void setSelectedPin(Pin pin) {
        this.currentPin = pin;
        this.matrixPanel.setSelectedPin(pin);
    }

    public void errorDialog(String string) {
        ErrorDialog errorDialog = new ErrorDialog(this, string);
        errorDialog.setLocationRelativeTo(this);
        errorDialog.show();
    }

    public void errorDialog(Exception exception) {
        String string = "Stack trace:\n";
        for (int i = 0; i < exception.getStackTrace().length; ++i) {
            string = string + exception.getStackTrace()[i].toString() + "\n";
        }
        this.errorDialog("Exception occured: \n" + exception.toString() + "\n\n" + string);
    }

    public void newGame(MatrixInterface matrixInterface) {
        this.matrix = matrixInterface;
        this.setupContentPane();
    }

    public void setGuessingPlayer(GuessingPlayerInterface guessingPlayerInterface) {
        this.guessingPlayer = guessingPlayerInterface;
        if (this.nameTextField != null) {
            this.nameTextField.setText(guessingPlayerInterface.getName());
        }
    }

    public void giveUp(Pin[] pinArray, long l) {
        this.matrixPanel.solved(pinArray);
        this.matrixPanel.solved(pinArray);
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(l);
        this.notifyUser("Schade, dass du nach " + calendar.get(12) + ":" + calendar.get(13) + " schon aufgibst, dabei w\u00e4re die L\u00f6sung doch so einfach gewesen...");
    }

    public void gameLost(Pin[] pinArray, long l) {
        this.matrixPanel.solved(pinArray);
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(l);
        this.notifyUser("Sorry, du hast leider verloren :-(\nDeine Spielzeit: " + calendar.get(12) + ":" + calendar.get(13));
    }

    public void notifyUser(String string) {
        NotifyDialog notifyDialog = new NotifyDialog(this, string);
        notifyDialog.setLocationRelativeTo(this);
        notifyDialog.show();
    }

    public String getTextFromUser(String string, String string2) {
        AskUser askUser = new AskUser(this, string, string2);
        askUser.setLocationRelativeTo(this);
        askUser.show();
        return askUser.getAnswer();
    }

    public void showSplash(int n) {
        SplashScreen splashScreen = new SplashScreen(this, n);
        splashScreen.setLocationRelativeTo(this);
        ((Window)splashScreen).show();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ void access$1700(GUI gUI, OptionChangeEvent optionChangeEvent) {
        gUI.fireOptionsEvent(optionChangeEvent);
    }

    private class GUIMouseWheelListener
    implements MouseWheelListener {
        private GUIMouseWheelListener() {
        }

        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            int n;
            Pin pin = GUI.this.matrixPanel.getSelectedPin();
            int n2 = 0;
            if (pin != null) {
                n2 = pin.getType() - 1;
            }
            if ((n = (n2 + mouseWheelEvent.getWheelRotation()) % GUI.this.matrix.getNumberOfPinTypes()) < 0) {
                n = GUI.this.matrix.getNumberOfPinTypes() - 1;
            }
            GUI.this.matrixPanel.setSelectedPin(new Pin(n + 1));
        }
    }

    private class OptionsDialog
    extends JDialog {
        private int maxRows = 8;
        private int minRows = 4;
        private int maxColumns = 8;
        private int minColumns = 1;
        private int minPinTypes = 2;
        private boolean correctionOrder = GUI.access$000(GUI.this).getCorrectionOrder();
        private boolean multiColorMode = GUI.access$000(GUI.this).getMultiColorMode();
        private int numberOfPlayers = 1;
        private int pinDesign;
        private JTextField playerNameField;
        private SpinnerNumberModel rowSpinnerModel = new SpinnerNumberModel();
        private SpinnerNumberModel columnSpinnerModel = new SpinnerNumberModel();
        private SpinnerNumberModel pinTypesSpinnerModel = new SpinnerNumberModel();

        public OptionsDialog(JFrame jFrame) {
            super(jFrame, "Options", false);
            this.pinDesign = GUI.this.pinVariation;
            this.setLocationRelativeTo(jFrame);
            this.setSize(500, 300);
            this.getContentPane().setLayout(new GridLayout(4, 2));
            JRadioButton[] jRadioButtonArray = new JRadioButton[]{new JRadioButton("Einfarbig"), new JRadioButton("Mehrfarbig")};
            ButtonGroup buttonGroup = new ButtonGroup();
            jRadioButtonArray[0].setSelected(!this.multiColorMode);
            jRadioButtonArray[1].setSelected(this.multiColorMode);
            jRadioButtonArray[0].addActionListener(new ActionListener(this){
                private final /* synthetic */ OptionsDialog this$1;
                {
                    this.this$1 = optionsDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    OptionsDialog.access$702(this.this$1, false);
                    OptionsDialog.access$800(this.this$1);
                }
            });
            jRadioButtonArray[1].addActionListener(new ActionListener(this){
                private final /* synthetic */ OptionsDialog this$1;
                {
                    this.this$1 = optionsDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    OptionsDialog.access$702(this.this$1, true);
                    OptionsDialog.access$800(this.this$1);
                    OptionsDialog.access$1000(this.this$1).setMaximum(new Integer(OptionsDialog.access$900(this.this$1)));
                }
            });
            JPanel jPanel = new JPanel();
            jPanel.setBorder(BorderFactory.createTitledBorder("Modus"));
            for (int i = 0; i < jRadioButtonArray.length; ++i) {
                jPanel.add(jRadioButtonArray[i]);
                buttonGroup.add(jRadioButtonArray[i]);
            }
            this.getContentPane().add(jPanel);
            JRadioButton[] jRadioButtonArray2 = new JRadioButton[]{new JRadioButton("Easy"), new JRadioButton("Normal")};
            ButtonGroup buttonGroup2 = new ButtonGroup();
            jRadioButtonArray2[0].setSelected(this.correctionOrder);
            jRadioButtonArray2[1].setSelected(!this.correctionOrder);
            jRadioButtonArray2[0].addActionListener(new ActionListener(this){
                private final /* synthetic */ OptionsDialog this$1;
                {
                    this.this$1 = optionsDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    OptionsDialog.access$1102(this.this$1, true);
                }
            });
            jRadioButtonArray2[1].addActionListener(new ActionListener(this){
                private final /* synthetic */ OptionsDialog this$1;
                {
                    this.this$1 = optionsDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    OptionsDialog.access$1102(this.this$1, false);
                }
            });
            JPanel jPanel2 = new JPanel();
            jPanel2.setBorder(BorderFactory.createTitledBorder("Level"));
            for (int i = 0; i < jRadioButtonArray2.length; ++i) {
                jPanel2.add(jRadioButtonArray2[i]);
                buttonGroup2.add(jRadioButtonArray2[i]);
            }
            this.getContentPane().add(jPanel2);
            JPanel jPanel3 = new JPanel();
            JLabel jLabel = new JLabel("Pin Auswahl:");
            this.pinTypesSpinnerModel.setMinimum(new Integer(this.minPinTypes));
            this.pinTypesSpinnerModel.setStepSize(new Integer(1));
            this.pinTypesSpinnerModel.setValue(new Integer(GUI.this.matrix.getNumberOfPinTypes()));
            this.checkValues();
            JSpinner jSpinner = new JSpinner(this.pinTypesSpinnerModel);
            jSpinner.addChangeListener(new ChangeListener(this){
                private final /* synthetic */ OptionsDialog this$1;
                {
                    this.this$1 = optionsDialog;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    OptionsDialog.access$800(this.this$1);
                }
            });
            jPanel3.add(jLabel);
            jPanel3.add(jSpinner);
            jPanel3.setBorder(BorderFactory.createTitledBorder("Anzahl Pins"));
            this.getContentPane().add(jPanel3);
            JPanel jPanel4 = new JPanel();
            JLabel jLabel2 = new JLabel("Zeilen:");
            JLabel jLabel3 = new JLabel("Spalten:");
            this.rowSpinnerModel.setMaximum(new Integer(this.maxRows));
            this.rowSpinnerModel.setMinimum(new Integer(this.minRows));
            this.rowSpinnerModel.setStepSize(new Integer(1));
            this.rowSpinnerModel.setValue(new Integer(GUI.this.matrix.getSizeY()));
            this.columnSpinnerModel.setMinimum(new Integer(this.minColumns));
            this.columnSpinnerModel.setStepSize(new Integer(1));
            this.columnSpinnerModel.setValue(new Integer(GUI.this.matrix.getSizeX()));
            this.checkValues();
            JSpinner jSpinner2 = new JSpinner(this.rowSpinnerModel);
            JSpinner jSpinner3 = new JSpinner(this.columnSpinnerModel);
            jPanel4.add(new JPanel().add(jLabel2));
            jPanel4.add(new JPanel().add(jSpinner2));
            jPanel4.add(new JPanel().add(jLabel3));
            jPanel4.add(new JPanel().add(jSpinner3));
            jPanel4.setBorder(BorderFactory.createTitledBorder("Spielfeld"));
            this.getContentPane().add(jPanel4);
            String[] stringArray = new String[GUI.this.converter.getNumberOfVariations()];
            for (int i = 0; i < GUI.this.converter.getNumberOfVariations(); ++i) {
                stringArray[i] = GUI.this.converter.getDescription(i + 1);
            }
            JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
            if (Globals.getDebugLevel() > 0) {
                System.out.println(this.getClass() + ": pin design: " + this.pinDesign);
            }
            jComboBox.setSelectedIndex(this.pinDesign - 1);
            jComboBox.addActionListener(new ActionListener(this){
                private final /* synthetic */ OptionsDialog this$1;
                {
                    this.this$1 = optionsDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    OptionsDialog.access$1302(this.this$1, ((JComboBox)actionEvent.getSource()).getSelectedIndex() + 1);
                    OptionsDialog.access$800(this.this$1);
                }
            });
            JPanel jPanel5 = new JPanel();
            jPanel5.add(jComboBox);
            jPanel5.setBorder(BorderFactory.createTitledBorder("Design"));
            this.getContentPane().add(jPanel5);
            String[] stringArray2 = new String[]{"Deutsch"};
            JComboBox<String> jComboBox2 = new JComboBox<String>(stringArray2);
            JPanel jPanel6 = new JPanel();
            jPanel6.add(jComboBox2);
            jPanel6.setBorder(BorderFactory.createTitledBorder("Sprache"));
            this.getContentPane().add(jPanel6);
            this.playerNameField = new JTextField(GUI.this.guessingPlayer.getName());
            this.playerNameField.setColumns(10);
            JPanel jPanel7 = new JPanel();
            jPanel7.add(this.playerNameField);
            jPanel7.setBorder(BorderFactory.createTitledBorder("Name"));
            this.getContentPane().add(jPanel7);
            JPanel jPanel8 = new JPanel();
            JButton jButton = new JButton("OK");
            JButton jButton2 = new JButton("Abbrechen");
            jButton2.addActionListener(new ActionListener(this){
                private final /* synthetic */ OptionsDialog this$1;
                {
                    this.this$1 = optionsDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.hide();
                }
            });
            jButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ OptionsDialog this$1;
                {
                    this.this$1 = optionsDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    boolean bl = this.this$1.getCorrectionOrderStatus();
                    boolean bl2 = this.this$1.getMultiColorStatus();
                    int n = this.this$1.getNumberOfPinTypes();
                    int n2 = this.this$1.getNumberOfPlayers();
                    int n3 = this.this$1.getNumberOfColumns();
                    int n4 = this.this$1.getNumberOfRows();
                    OptionChangeEvent optionChangeEvent = new OptionChangeEvent(bl, bl2, n, n3, n4, n2, OptionsDialog.access$1500(this.this$1).getText(), OptionsDialog.access$1300(this.this$1));
                    GUI.access$1700(OptionsDialog.access$1600(this.this$1), optionChangeEvent);
                    this.this$1.hide();
                }
            });
            jPanel8.add(jButton);
            jPanel8.add(jButton2);
            this.getContentPane().add(jPanel8);
        }

        private void checkValues() {
            int n;
            int n2 = this.getNumberOfPinTypes();
            if (n2 > (n = GUI.this.converter.getNumberOfTypes(this.pinDesign))) {
                n2 = n;
                this.pinTypesSpinnerModel.setValue(new Integer(n2));
            }
            this.pinTypesSpinnerModel.setMaximum(new Integer(n));
            if (this.multiColorMode) {
                this.columnSpinnerModel.setMaximum(new Integer(this.maxColumns));
            } else {
                int n3 = Math.min(this.maxColumns, n2);
                if (this.getNumberOfColumns() > n3) {
                    this.columnSpinnerModel.setValue(new Integer(n3));
                }
                this.columnSpinnerModel.setMaximum(new Integer(n3));
            }
        }

        public boolean getMultiColorStatus() {
            return this.multiColorMode;
        }

        public boolean getCorrectionOrderStatus() {
            return this.correctionOrder;
        }

        public int getNumberOfPinTypes() {
            return (Integer)this.pinTypesSpinnerModel.getValue();
        }

        public int getNumberOfPlayers() {
            return this.numberOfPlayers;
        }

        public int getNumberOfColumns() {
            return (Integer)this.columnSpinnerModel.getValue();
        }

        public int getNumberOfRows() {
            return (Integer)this.rowSpinnerModel.getValue();
        }

        static /* synthetic */ boolean access$702(OptionsDialog optionsDialog, boolean bl) {
            optionsDialog.multiColorMode = bl;
            return optionsDialog.multiColorMode;
        }

        static /* synthetic */ void access$800(OptionsDialog optionsDialog) {
            optionsDialog.checkValues();
        }

        static /* synthetic */ int access$900(OptionsDialog optionsDialog) {
            return optionsDialog.maxColumns;
        }

        static /* synthetic */ SpinnerNumberModel access$1000(OptionsDialog optionsDialog) {
            return optionsDialog.columnSpinnerModel;
        }

        static /* synthetic */ boolean access$1102(OptionsDialog optionsDialog, boolean bl) {
            optionsDialog.correctionOrder = bl;
            return optionsDialog.correctionOrder;
        }

        static /* synthetic */ int access$1302(OptionsDialog optionsDialog, int n) {
            optionsDialog.pinDesign = n;
            return optionsDialog.pinDesign;
        }

        static /* synthetic */ JTextField access$1500(OptionsDialog optionsDialog) {
            return optionsDialog.playerNameField;
        }

        static /* synthetic */ int access$1300(OptionsDialog optionsDialog) {
            return optionsDialog.pinDesign;
        }

        static /* synthetic */ GUI access$1600(OptionsDialog optionsDialog) {
            return optionsDialog.GUI.this;
        }
    }

    private class ErrorDialog
    extends JDialog {
        public ErrorDialog(JFrame jFrame, String string) {
            super(jFrame, "B0rk3d!", true);
            this.setSize(800, 600);
            this.setResizable(true);
            this.setModal(true);
            this.setLocationRelativeTo(jFrame);
            this.getContentPane().setLayout(new BorderLayout());
            JLabel jLabel = new JLabel("B0rk3d!");
            this.getContentPane().add((Component)jLabel, "North");
            JTextArea jTextArea = new JTextArea(string);
            JScrollPane jScrollPane = new JScrollPane(jTextArea);
            this.getContentPane().add((Component)jScrollPane, "Center");
            JPanel jPanel = new JPanel();
            JButton jButton = new JButton("ok");
            jPanel.add(jButton);
            jButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ ErrorDialog this$1;
                {
                    this.this$1 = errorDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.hide();
                }
            });
            this.getContentPane().add((Component)jPanel, "South");
        }
    }

    private class AskUser
    extends JDialog {
        private String answer = "";
        private JTextField answerField;

        public AskUser(JFrame jFrame, String string, String string2) {
            super(jFrame, "Eingabe", true);
            this.setSize(300, 150);
            this.setResizable(true);
            this.setLocationRelativeTo(jFrame);
            this.getContentPane().setLayout(new BorderLayout());
            JTextArea jTextArea = new JTextArea(string);
            jTextArea.setWrapStyleWord(true);
            jTextArea.setLineWrap(true);
            JPanel jPanel = new JPanel();
            jTextArea.setEditable(false);
            JScrollPane jScrollPane = new JScrollPane(jTextArea);
            this.getContentPane().add((Component)jScrollPane, "Center");
            JPanel jPanel2 = new JPanel(new BorderLayout());
            JLabel jLabel = new JLabel("Eingabe:");
            this.answerField = new JTextField(string2);
            JPanel jPanel3 = new JPanel(new BorderLayout());
            jPanel3.add((Component)jLabel, "West");
            jPanel3.add((Component)this.answerField, "Center");
            jPanel2.add((Component)jPanel3, "Center");
            JButton jButton = new JButton("OK");
            jButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ AskUser this$1;
                {
                    this.this$1 = askUser;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    AskUser.access$502(this.this$1, this.this$1.getAnswer());
                    this.this$1.hide();
                }
            });
            JPanel jPanel4 = new JPanel();
            jPanel4.add(jButton);
            jPanel2.add((Component)jPanel4, "South");
            this.getContentPane().add((Component)jPanel2, "South");
        }

        public String getAnswer() {
            return this.answerField.getText();
        }

        static /* synthetic */ String access$502(AskUser askUser, String string) {
            askUser.answer = string;
            return askUser.answer;
        }
    }

    private class YesNoDialog
    extends JDialog {
        int answer = 0;

        public YesNoDialog(JFrame jFrame, String string) {
            super(jFrame, "Frage", true);
            Accessible accessible;
            this.setSize(300, 150);
            this.setResizable(true);
            this.setLocationRelativeTo(jFrame);
            this.getContentPane().setLayout(new BorderLayout());
            JTextArea jTextArea = new JTextArea(string);
            jTextArea.setWrapStyleWord(true);
            jTextArea.setLineWrap(true);
            JPanel jPanel = new JPanel();
            jTextArea.setEditable(false);
            JScrollPane jScrollPane = new JScrollPane(jTextArea);
            this.getContentPane().add((Component)jScrollPane, "Center");
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new GridLayout(1, 3));
            JLabel jLabel = new JLabel();
            URL uRL = this.getClass().getResource("image/question.gif");
            if (uRL != null) {
                accessible = new ImageIcon(uRL);
                jLabel.setIcon((Icon)((Object)accessible));
                this.getContentPane().add((Component)jLabel, "West");
            } else if (Globals.getDebugLevel() > 0) {
                System.err.println(this.getClass() + ": Warning: question image could not be loaded");
            }
            accessible = new JPanel();
            JButton jButton = new JButton("Ja");
            jButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ YesNoDialog this$1;
                {
                    this.this$1 = yesNoDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.answer = 1;
                    this.this$1.hide();
                }
            });
            ((Container)((Object)accessible)).add(jButton);
            jPanel2.add((Component)((Object)accessible));
            JPanel jPanel3 = new JPanel();
            JButton jButton2 = new JButton("Nein");
            jButton2.addActionListener(new ActionListener(this){
                private final /* synthetic */ YesNoDialog this$1;
                {
                    this.this$1 = yesNoDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.answer = 2;
                    this.this$1.hide();
                }
            });
            jPanel3.add(jButton2);
            jPanel2.add(jPanel3);
            JPanel jPanel4 = new JPanel();
            JButton jButton3 = new JButton("Abbrechen");
            jButton3.addActionListener(new ActionListener(this){
                private final /* synthetic */ YesNoDialog this$1;
                {
                    this.this$1 = yesNoDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.answer = 0;
                    this.this$1.hide();
                }
            });
            jPanel4.add(jButton3);
            jPanel2.add(jPanel4);
            this.getContentPane().add((Component)jPanel2, "South");
        }

        public int getAnswer() {
            return this.answer;
        }
    }

    private class NotifyDialog
    extends JDialog {
        public NotifyDialog(JFrame jFrame, String string) {
            super(jFrame, "Hinweis", true);
            this.setLocationRelativeTo(jFrame);
            this.setSize(300, 150);
            this.setResizable(true);
            this.setLocationRelativeTo(jFrame);
            this.getContentPane().setLayout(new BorderLayout());
            JTextArea jTextArea = new JTextArea(string);
            jTextArea.setWrapStyleWord(true);
            jTextArea.setLineWrap(true);
            JPanel jPanel = new JPanel();
            jTextArea.setEditable(false);
            JScrollPane jScrollPane = new JScrollPane(jTextArea);
            this.getContentPane().add((Component)jScrollPane, "Center");
            JPanel jPanel2 = new JPanel();
            JButton jButton = new JButton("OK");
            jPanel2.add(jButton);
            jButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ NotifyDialog this$1;
                {
                    this.this$1 = notifyDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.hide();
                }
            });
            this.getContentPane().add((Component)jPanel2, "South");
        }
    }

    private class SplashScreen
    extends JWindow
    implements ActionListener {
        private String splashPath = "image/splash.jpg";
        private Timer timer;

        public SplashScreen(JFrame jFrame, int n) {
            super(jFrame);
            this.setLocationRelativeTo(jFrame);
            this.timer = new Timer(n, this);
            URL uRL = this.getClass().getResource(this.splashPath);
            if (uRL != null) {
                ImageIcon imageIcon = new ImageIcon(uRL);
                this.setSize(imageIcon.getIconWidth(), imageIcon.getIconHeight());
                JLabel jLabel = new JLabel(imageIcon);
                this.getContentPane().add(jLabel);
            } else {
                System.err.println("Warning: splash screen not found at " + this.splashPath);
            }
        }

        public void show() {
            super.show();
            this.timer.start();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.hide();
            this.dispose();
        }
    }

    private class AboutDialog
    extends JDialog {
        private String aboutImagePath = "image/splash.jpg";

        public AboutDialog(JFrame jFrame) {
            super(jFrame, "About", true);
            JComponent jComponent;
            Accessible accessible;
            this.setSize(300, 200);
            this.setResizable(false);
            this.setLocationRelativeTo(jFrame);
            this.getContentPane().setLayout(new BorderLayout());
            URL uRL = this.getClass().getResource(this.aboutImagePath);
            if (uRL != null) {
                accessible = new ImageIcon(uRL);
                this.setSize(((ImageIcon)accessible).getIconWidth(), ((ImageIcon)accessible).getIconHeight() + 150);
                jComponent = new JLabel((Icon)((Object)accessible));
                this.getContentPane().add((Component)jComponent, "North");
            } else {
                System.err.println("Warning: image not found at " + this.aboutImagePath);
            }
            accessible = new JTextArea("This ist the full-overkill-mastermind application\n(c) 2004 by ThePhreakCrew");
            ((JComponent)((Object)accessible)).setEnabled(false);
            ((JTextArea)accessible).setLineWrap(true);
            ((JTextArea)accessible).setWrapStyleWord(true);
            jComponent = new JScrollPane((Component)((Object)accessible));
            this.getContentPane().add((Component)jComponent, "Center");
            JPanel jPanel = new JPanel();
            JButton jButton = new JButton("OK");
            jButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ AboutDialog this$1;
                {
                    this.this$1 = aboutDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.hide();
                }
            });
            jPanel.add(jButton);
            this.getContentPane().add((Component)jPanel, "South");
        }
    }

    private class HiscoreDialog
    extends JDialog {
        private int maxRows = 8;
        private int minRows = 4;
        private int maxColumns = 8;
        private int minColumns = 1;
        private int maxPinTypes = 9;
        private int minPinTypes = 2;
        private Hiscore hiscore;
        private boolean filter = true;
        private boolean correctionOrder = GUI.access$000(GUI.this).getCorrectionOrder();
        private boolean multiColorMode = GUI.access$000(GUI.this).getMultiColorMode();
        private int pinDesign;
        private JTextField playerNameField;
        private SpinnerNumberModel rowSpinnerModel = new SpinnerNumberModel();
        private SpinnerNumberModel columnSpinnerModel = new SpinnerNumberModel();
        private SpinnerNumberModel pinTypesSpinnerModel = new SpinnerNumberModel();
        private JTable contentTable = new JTable();
        private HiscoreTableModel hiscoreTableModel;

        public HiscoreDialog(JFrame jFrame, Hiscore hiscore) {
            super(jFrame, "Highscore", true);
            this.setSize(800, 600);
            this.setResizable(true);
            this.setLocationRelativeTo(jFrame);
            this.getContentPane().setLayout(new BorderLayout());
            ListIterator listIterator = hiscore.getHiscoreEntries().listIterator();
            this.hiscore = hiscore;
            this.multiColorMode = GUI.this.matrix.getMultiColorMode();
            this.correctionOrder = GUI.this.matrix.getCorrectionOrder();
            this.pinTypesSpinnerModel.setValue(new Integer(GUI.this.matrix.getNumberOfPinTypes()));
            this.columnSpinnerModel.setValue(new Integer(GUI.this.matrix.getSizeX()));
            this.rowSpinnerModel.setValue(new Integer(GUI.this.matrix.getSizeY()));
            this.createFilterPanel();
            this.createTable(hiscore, true, this.multiColorMode, this.correctionOrder, Integer.parseInt(this.pinTypesSpinnerModel.getValue().toString()), Integer.parseInt(this.columnSpinnerModel.getValue().toString()), Integer.parseInt(this.rowSpinnerModel.getValue().toString()));
            this.hiscoreTableModel.addTableModelListener(this.contentTable);
            this.contentTable.setModel(this.hiscoreTableModel);
            JScrollPane jScrollPane = new JScrollPane(this.contentTable);
            this.getContentPane().add((Component)jScrollPane, "Center");
            JPanel jPanel = new JPanel();
            JButton jButton = new JButton("OK");
            jButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ HiscoreDialog this$1;
                {
                    this.this$1 = hiscoreDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.hide();
                }
            });
            jPanel.add(jButton);
            this.getContentPane().add((Component)jPanel, "South");
        }

        private void createTable(Hiscore hiscore, boolean bl, boolean bl2, boolean bl3, int n, int n2, int n3) {
            HiscoreEntry[] hiscoreEntryArray;
            Vector<HiscoreEntry> vector = new Vector<HiscoreEntry>();
            if (hiscore != null) {
                hiscoreEntryArray = hiscore.getHiscoreEntries();
                Iterator iterator = hiscoreEntryArray.iterator();
                while (iterator.hasNext()) {
                    HiscoreEntry hiscoreEntry = (HiscoreEntry)iterator.next();
                    boolean bl4 = true;
                    if (bl && hiscoreEntry.isMultiColor() != bl2) {
                        bl4 = false;
                    } else if (bl && hiscoreEntry.isCorrectionOrder() != bl3) {
                        bl4 = false;
                    } else if (bl && hiscoreEntry.getNumberOfPinTypes() != n) {
                        bl4 = false;
                    } else if (bl && hiscoreEntry.getColumns() != n2) {
                        bl4 = false;
                    } else if (bl && hiscoreEntry.getRows() != n3) {
                        bl4 = false;
                    }
                    if (!bl4) continue;
                    vector.add(hiscoreEntry);
                }
            }
            hiscoreEntryArray = new HiscoreEntry[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                hiscoreEntryArray[i] = (HiscoreEntry)vector.elementAt(i);
            }
            if (this.hiscoreTableModel == null) {
                this.hiscoreTableModel = new HiscoreTableModel(hiscoreEntryArray);
            } else {
                this.hiscoreTableModel.setContent(hiscoreEntryArray);
            }
        }

        private void updateTable() {
            this.createTable(this.hiscore, this.filter, this.multiColorMode, this.correctionOrder, Integer.parseInt(this.pinTypesSpinnerModel.getValue().toString()), Integer.parseInt(this.columnSpinnerModel.getValue().toString()), Integer.parseInt(this.rowSpinnerModel.getValue().toString()));
        }

        private void createFilterPanel() {
            JRadioButton[] jRadioButtonArray = new JRadioButton[]{new JRadioButton("Einfarbig"), new JRadioButton("Mehrfarbig")};
            ButtonGroup buttonGroup = new ButtonGroup();
            jRadioButtonArray[0].setSelected(!this.multiColorMode);
            jRadioButtonArray[1].setSelected(this.multiColorMode);
            jRadioButtonArray[0].addActionListener(new ActionListener(this){
                private final /* synthetic */ HiscoreDialog this$1;
                {
                    this.this$1 = hiscoreDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    HiscoreDialog.access$102(this.this$1, false);
                    HiscoreDialog.access$200(this.this$1);
                }
            });
            jRadioButtonArray[1].addActionListener(new ActionListener(this){
                private final /* synthetic */ HiscoreDialog this$1;
                {
                    this.this$1 = hiscoreDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    HiscoreDialog.access$102(this.this$1, true);
                    HiscoreDialog.access$200(this.this$1);
                }
            });
            JPanel jPanel = new JPanel();
            jPanel.setBorder(BorderFactory.createTitledBorder("Modus"));
            for (int i = 0; i < jRadioButtonArray.length; ++i) {
                jPanel.add(jRadioButtonArray[i]);
                buttonGroup.add(jRadioButtonArray[i]);
            }
            JRadioButton[] jRadioButtonArray2 = new JRadioButton[]{new JRadioButton("Easy"), new JRadioButton("Normal")};
            ButtonGroup buttonGroup2 = new ButtonGroup();
            jRadioButtonArray2[0].setSelected(this.correctionOrder);
            jRadioButtonArray2[1].setSelected(!this.correctionOrder);
            jRadioButtonArray2[0].addActionListener(new ActionListener(this){
                private final /* synthetic */ HiscoreDialog this$1;
                {
                    this.this$1 = hiscoreDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    HiscoreDialog.access$302(this.this$1, true);
                    HiscoreDialog.access$200(this.this$1);
                }
            });
            jRadioButtonArray2[1].addActionListener(new ActionListener(this){
                private final /* synthetic */ HiscoreDialog this$1;
                {
                    this.this$1 = hiscoreDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    HiscoreDialog.access$302(this.this$1, false);
                    HiscoreDialog.access$200(this.this$1);
                }
            });
            JPanel jPanel2 = new JPanel();
            jPanel2.setBorder(BorderFactory.createTitledBorder("Level"));
            for (int i = 0; i < jRadioButtonArray2.length; ++i) {
                jPanel2.add(jRadioButtonArray2[i]);
                buttonGroup2.add(jRadioButtonArray2[i]);
            }
            JPanel jPanel3 = new JPanel();
            JLabel jLabel = new JLabel("Pin Auswahl:");
            this.pinTypesSpinnerModel.setMaximum(new Integer(this.maxPinTypes));
            this.pinTypesSpinnerModel.setMinimum(new Integer(this.minPinTypes));
            this.pinTypesSpinnerModel.setStepSize(new Integer(1));
            this.pinTypesSpinnerModel.setValue(new Integer(GUI.this.matrix.getNumberOfPinTypes()));
            JSpinner jSpinner = new JSpinner(this.pinTypesSpinnerModel);
            jSpinner.addChangeListener(new ChangeListener(this){
                private final /* synthetic */ HiscoreDialog this$1;
                {
                    this.this$1 = hiscoreDialog;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    HiscoreDialog.access$200(this.this$1);
                }
            });
            jPanel3.add(jLabel);
            jPanel3.add(jSpinner);
            jPanel3.setBorder(BorderFactory.createTitledBorder("Anzahl Pins"));
            JPanel jPanel4 = new JPanel();
            JLabel jLabel2 = new JLabel("Zeilen:");
            JLabel jLabel3 = new JLabel("Spalten:");
            this.rowSpinnerModel.setMaximum(new Integer(this.maxRows));
            this.rowSpinnerModel.setMinimum(new Integer(this.minRows));
            this.rowSpinnerModel.setStepSize(new Integer(1));
            this.rowSpinnerModel.setValue(new Integer(GUI.this.matrix.getSizeY()));
            this.columnSpinnerModel.setMinimum(new Integer(this.minColumns));
            this.columnSpinnerModel.setStepSize(new Integer(1));
            this.columnSpinnerModel.setValue(new Integer(GUI.this.matrix.getSizeX()));
            JSpinner jSpinner2 = new JSpinner(this.rowSpinnerModel);
            jSpinner2.addChangeListener(new ChangeListener(this){
                private final /* synthetic */ HiscoreDialog this$1;
                {
                    this.this$1 = hiscoreDialog;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    HiscoreDialog.access$200(this.this$1);
                }
            });
            JSpinner jSpinner3 = new JSpinner(this.columnSpinnerModel);
            jSpinner3.addChangeListener(new ChangeListener(this){
                private final /* synthetic */ HiscoreDialog this$1;
                {
                    this.this$1 = hiscoreDialog;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    HiscoreDialog.access$200(this.this$1);
                }
            });
            jPanel4.add(new JPanel().add(jLabel2));
            jPanel4.add(new JPanel().add(jSpinner2));
            jPanel4.add(new JPanel().add(jLabel3));
            jPanel4.add(new JPanel().add(jSpinner3));
            jPanel4.setBorder(BorderFactory.createTitledBorder("Spielfeld"));
            JCheckBox jCheckBox = new JCheckBox();
            jCheckBox.setSelected(this.filter);
            jCheckBox.addChangeListener(new ChangeListener(this){
                private final /* synthetic */ HiscoreDialog this$1;
                {
                    this.this$1 = hiscoreDialog;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    HiscoreDialog.access$402(this.this$1, ((JCheckBox)changeEvent.getSource()).isSelected());
                    HiscoreDialog.access$200(this.this$1);
                }
            });
            JPanel jPanel5 = new JPanel();
            jPanel5.setBorder(BorderFactory.createTitledBorder("Filter"));
            jPanel5.add(jCheckBox);
            JPanel jPanel6 = new JPanel();
            jPanel6.add(jPanel5);
            jPanel6.add(jPanel);
            jPanel6.add(jPanel2);
            jPanel6.add(jPanel3);
            jPanel6.add(jPanel4);
            JScrollPane jScrollPane = new JScrollPane(jPanel6);
            this.getContentPane().add((Component)jScrollPane, "North");
        }

        static /* synthetic */ boolean access$102(HiscoreDialog hiscoreDialog, boolean bl) {
            hiscoreDialog.multiColorMode = bl;
            return hiscoreDialog.multiColorMode;
        }

        static /* synthetic */ void access$200(HiscoreDialog hiscoreDialog) {
            hiscoreDialog.updateTable();
        }

        static /* synthetic */ boolean access$302(HiscoreDialog hiscoreDialog, boolean bl) {
            hiscoreDialog.correctionOrder = bl;
            return hiscoreDialog.correctionOrder;
        }

        static /* synthetic */ boolean access$402(HiscoreDialog hiscoreDialog, boolean bl) {
            hiscoreDialog.filter = bl;
            return hiscoreDialog.filter;
        }

        private class HiscoreTableModel
        implements TableModel {
            private HiscoreEntry[] entries;
            private Vector tableModelListeners = new Vector();

            public HiscoreTableModel(HiscoreEntry[] hiscoreEntryArray) {
                this.setContent(hiscoreEntryArray);
            }

            public void setContent(HiscoreEntry[] hiscoreEntryArray) {
                this.entries = hiscoreEntryArray;
                Iterator iterator = this.tableModelListeners.iterator();
                while (iterator.hasNext()) {
                    TableModelListener tableModelListener = (TableModelListener)iterator.next();
                    tableModelListener.tableChanged(new TableModelEvent(this));
                }
            }

            public void addTableModelListener(TableModelListener tableModelListener) {
                this.tableModelListeners.add(tableModelListener);
            }

            public Class getColumnClass(int n) {
                return class$java$lang$String == null ? (class$java$lang$String = GUI.class$("java.lang.String")) : class$java$lang$String;
            }

            public int getColumnCount() {
                return 8;
            }

            public String getColumnName(int n) {
                String string = "";
                switch (n) {
                    case 0: {
                        string = "Spielername";
                        break;
                    }
                    case 1: {
                        string = "Datum";
                        break;
                    }
                    case 2: {
                        string = "Zeit";
                        break;
                    }
                    case 3: {
                        string = "MC";
                        break;
                    }
                    case 4: {
                        string = "Mode";
                        break;
                    }
                    case 5: {
                        string = "Pins";
                        break;
                    }
                    case 6: {
                        string = "Spalten";
                        break;
                    }
                    case 7: {
                        string = "Zeilen";
                        break;
                    }
                    default: {
                        string = "unknown";
                    }
                }
                return string;
            }

            public int getRowCount() {
                if (this.entries != null) {
                    return this.entries.length;
                }
                return 0;
            }

            public Object getValueAt(int n, int n2) {
                String string = "";
                HiscoreEntry hiscoreEntry = this.entries[n];
                switch (n2) {
                    case 0: {
                        string = hiscoreEntry.getPlayerName();
                        break;
                    }
                    case 1: {
                        string = hiscoreEntry.getDate().toString();
                        break;
                    }
                    case 2: {
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTimeInMillis(hiscoreEntry.getTime());
                        string = calendar.get(12) + ":" + calendar.get(13);
                        break;
                    }
                    case 3: {
                        if (hiscoreEntry.isMultiColor()) {
                            string = "Yes";
                            break;
                        }
                        string = "No";
                        break;
                    }
                    case 4: {
                        if (hiscoreEntry.isCorrectionOrder()) {
                            string = "Easy";
                            break;
                        }
                        string = "Normal";
                        break;
                    }
                    case 5: {
                        string = String.valueOf(hiscoreEntry.getNumberOfPinTypes());
                        break;
                    }
                    case 6: {
                        string = String.valueOf(hiscoreEntry.getColumns());
                        break;
                    }
                    case 7: {
                        string = String.valueOf(hiscoreEntry.getRows());
                        break;
                    }
                    default: {
                        string = "unknown";
                    }
                }
                return string;
            }

            public boolean isCellEditable(int n, int n2) {
                return false;
            }

            public void removeTableModelListener(TableModelListener tableModelListener) {
                this.tableModelListeners.remove(tableModelListener);
            }

            public void setValueAt(Object object, int n, int n2) {
                System.err.println(this.getClass() + ": Error, tried to change table; row: " + n + ", column: " + n2);
            }
        }
    }

    private class HelpDialog
    extends JDialog
    implements ActionListener {
        private JTextPane helpPane;
        private String helpIndex = "help/index.htm";
        private String backButtonImage = "image/back.gif";
        private String forwardButtonImage = "image/forward.gif";
        private String homeButtonImage = "image/home.gif";
        private Vector history = new Vector();
        private int historyIndex = 0;

        public HelpDialog(JFrame jFrame) {
            super(jFrame, "Hilfe", false);
            this.setSize(800, 600);
            this.setResizable(true);
            this.setLocationRelativeTo(jFrame);
            this.getContentPane().setLayout(new BorderLayout());
            JPanel jPanel = new JPanel(new BorderLayout());
            JToolBar jToolBar = new JToolBar("Navigation");
            jToolBar.add(this.createNavButton(this.backButtonImage, "Zur\u00fcck", "back", "Zur\u00fcck zur vorherigen Seite", this));
            jToolBar.add(this.createNavButton(this.homeButtonImage, "Home", "home", "Zur\u00fcck zur Startseite", this));
            jToolBar.add(this.createNavButton(this.forwardButtonImage, "Vorw\u00e4rts", "forward", "Vorw\u00e4rts zur n\u00e4chsten Seite", this));
            jPanel.add((Component)jToolBar, "North");
            this.helpPane = new JTextPane();
            this.helpPane.setEditable(false);
            this.helpPane.addHyperlinkListener(new HyperlinkListener(){

                public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                    if (hyperlinkEvent.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                        this.setURL(hyperlinkEvent.getURL());
                    }
                }
            });
            this.setURL(this.helpIndex);
            JScrollPane jScrollPane = new JScrollPane(this.helpPane);
            jPanel.add((Component)jScrollPane, "Center");
            JPanel jPanel2 = new JPanel();
            JButton jButton = new JButton("OK");
            jButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ HelpDialog this$1;
                {
                    this.this$1 = helpDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.hide();
                }
            });
            jPanel2.add(jButton);
            this.getContentPane().add((Component)jPanel, "Center");
            this.getContentPane().add((Component)jPanel2, "South");
        }

        private JButton createNavButton(String string, String string2, String string3, String string4, ActionListener actionListener) {
            JButton jButton = new JButton();
            URL uRL = this.getClass().getResource(string);
            if (uRL != null) {
                jButton.setIcon(new ImageIcon(uRL, string4));
            } else {
                jButton.setText(string2);
                System.err.println("Warning: Image not found: " + string);
            }
            jButton.setActionCommand(string3);
            jButton.setToolTipText(string4);
            jButton.addActionListener(actionListener);
            return jButton;
        }

        public void setURL(String string) {
            URL uRL = (class$ch$skybeam$mastermind$Mastermind == null ? (class$ch$skybeam$mastermind$Mastermind = GUI.class$("ch.skybeam.mastermind.Mastermind")) : class$ch$skybeam$mastermind$Mastermind).getResource(string);
            if (uRL != null) {
                this.setURL(uRL);
                this.history.add(uRL);
            } else {
                System.err.println("Warning invalid path specified: " + string);
            }
        }

        public void setURL(URL uRL) {
            try {
                this.helpPane.setPage(uRL);
                while (this.historyIndex + 1 < this.history.size()) {
                    this.history.remove(this.historyIndex);
                }
                this.history.add(uRL);
                this.historyIndex = this.history.size() - 1;
            }
            catch (IOException iOException) {
                System.err.println("Attemp to read bad URL: " + uRL);
            }
        }

        private void historyFor(int n) {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getActionCommand() == "back") {
                if (this.historyIndex > 0) {
                    try {
                        this.helpPane.setPage((URL)this.history.get(--this.historyIndex));
                    }
                    catch (IOException iOException) {
                        System.err.println("Attemp to read bad URL");
                    }
                }
            } else if (actionEvent.getActionCommand() == "home") {
                this.setURL(this.helpIndex);
            } else if (actionEvent.getActionCommand() == "forward" && this.history.size() > this.historyIndex + 1) {
                try {
                    this.helpPane.setPage((URL)this.history.get(++this.historyIndex));
                }
                catch (IOException iOException) {
                    System.err.println("Attemp to read bad URL");
                }
            }
        }
    }
}

