/*
 * Decompiled with CFR 0.152.
 */
package ch.skybeam.mastermind.view;

import ch.skybeam.util.Globals;
import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.io.FileNotFoundException;
import java.net.URL;
import javax.naming.directory.InvalidAttributeValueException;
import javax.swing.JPanel;

public class HangmanPanel
extends JPanel
implements Runnable {
    private static final String rcsHeader = "$Header: /data/cvs/hta/Mastermind/src/ch/skybeam/mastermind/view/HangmanPanel.java,v 1.6 2004/01/29 18:39:54 rme Exp $";
    private static final String rcsName = "$Name: MASTERMIND_RELEASE_20040129 $";
    private static final String rcsRevision = "$Revision: 1.6 $";
    private boolean run = true;
    private int currentStep = 0;
    private int numberOfSteps = 8;
    private String headImagePath = "image/kennyHead.gif";
    private Image headImage;
    private String bodyImagePath = "image/kennyBody.gif";
    private Image bodyImage;
    private String finishSoundPath = "media/killedkenny.au";
    private AudioClip audioClip;
    private boolean finished = false;
    MediaTracker mediaTracker = new MediaTracker(this);
    private int variation = 15;
    private int refresh = 1000;
    private int numberOfFuzzyLines = 15;
    private int[] leg1End = new int[]{5, 0};
    private int[] leg2End = new int[]{0, 0};
    private int[] gibbetFoot = new int[]{0, 0};
    private int[] gibbetTopLeft = new int[]{0, 5};
    private int[] gibbetTopRight = new int[]{0, 5};
    private int[] head = new int[]{0, 0};

    public HangmanPanel(int n) throws FileNotFoundException {
        super(true);
        this.setBackground(Color.WHITE);
        this.numberOfSteps = n;
        URL uRL = this.getClass().getResource(this.headImagePath);
        if (uRL == null) {
            throw new FileNotFoundException("File " + this.headImagePath + " could not be found!");
        }
        this.headImage = Toolkit.getDefaultToolkit().getImage(uRL);
        this.mediaTracker.addImage(this.headImage, 0);
        URL uRL2 = this.getClass().getResource(this.bodyImagePath);
        if (uRL == null) {
            throw new FileNotFoundException("File " + this.bodyImagePath + " could not be found!");
        }
        this.bodyImage = Toolkit.getDefaultToolkit().getImage(uRL2);
        this.mediaTracker.addImage(this.bodyImage, 1);
        URL uRL3 = this.getClass().getResource(this.finishSoundPath);
        if (uRL3 != null) {
            this.audioClip = Applet.newAudioClip(uRL3);
        } else {
            System.err.println(this.getClass() + ": sound file not found " + this.finishSoundPath);
        }
    }

    public void run() {
        while (this.run) {
            this.repaint();
            try {
                Thread.sleep(this.refresh);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void nextStep() throws InvalidAttributeValueException {
        this.setStep(this.currentStep + 1);
    }

    public void setStep(int n) throws InvalidAttributeValueException {
        if (n >= 0 && n <= this.numberOfSteps) {
            this.currentStep = n;
            if (n == this.numberOfSteps) {
                this.finished = true;
                if (this.audioClip != null) {
                    this.audioClip.play();
                }
            }
        } else {
            throw new InvalidAttributeValueException("Error: specified invalid step number (" + n + ") - 0 < step < getNumberOfSteps()");
        }
        this.repaint();
    }

    public int getStep() {
        return this.currentStep;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        int n = this.getWidth() / 5;
        int n2 = this.getHeight() / 10;
        this.leg1End[1] = this.getHeight() - 5;
        this.gibbetFoot[0] = n;
        this.gibbetFoot[1] = 9 * n2;
        this.leg2End[0] = 2 * this.gibbetFoot[0] - this.leg1End[0];
        this.leg2End[1] = this.leg1End[1];
        this.gibbetTopLeft[0] = this.gibbetFoot[0];
        this.gibbetTopRight[0] = n * 3;
        this.head[0] = this.gibbetTopRight[0];
        this.head[1] = 4 * n2;
        if (Globals.getDebugLevel() > 9) {
            System.out.println(this.getClass() + ": leg1end: " + this.leg1End[0] + " - " + this.leg1End[1]);
            System.out.println(this.getClass() + ": leg2end: " + this.leg2End[0] + " - " + this.leg2End[1]);
            System.out.println(this.getClass() + ": gibbetfoot: " + this.gibbetFoot[0] + " - " + this.gibbetFoot[1]);
            System.out.println(this.getClass() + ": gibbetTopLeft: " + this.gibbetTopLeft[0] + " - " + this.gibbetTopLeft[1]);
            System.out.println(this.getClass() + ": gibbetTopRight: " + this.gibbetTopRight[0] + " - " + this.gibbetTopRight[1]);
            System.out.println(this.getClass() + ": head: " + this.head[0] + " - " + this.head[1]);
        }
        int n3 = 8;
        double d = (double)this.currentStep / (double)this.numberOfSteps;
        int n4 = (int)(d * (double)n3);
        if (Globals.getDebugLevel() > 9) {
            System.out.println("Current Step: " + n4);
        }
        graphics.setColor(new Color(120, 60, 30));
        switch (n4) {
            case 1: {
                this.drawStep1(graphics);
                break;
            }
            case 2: {
                this.drawStep1(graphics);
                this.drawStep2(graphics);
                break;
            }
            case 3: {
                this.drawStep1(graphics);
                this.drawStep2(graphics);
                this.drawStep3(graphics);
                break;
            }
            case 4: {
                this.drawStep1(graphics);
                this.drawStep2(graphics);
                this.drawStep3(graphics);
                this.drawStep4(graphics);
                break;
            }
            case 5: {
                this.drawStep1(graphics);
                this.drawStep2(graphics);
                this.drawStep3(graphics);
                this.drawStep4(graphics);
                this.drawStep5(graphics);
                break;
            }
            case 6: {
                this.drawStep1(graphics);
                this.drawStep2(graphics);
                this.drawStep3(graphics);
                this.drawStep5(graphics);
                this.drawStep4(graphics);
                this.drawStep6(graphics);
                break;
            }
            case 7: {
                this.drawStep1(graphics);
                this.drawStep2(graphics);
                this.drawStep3(graphics);
                this.drawStep4(graphics);
                this.drawStep5(graphics);
                this.drawStep6(graphics);
                this.drawStep7(graphics);
                break;
            }
            case 8: {
                this.drawStep1(graphics);
                this.drawStep2(graphics);
                this.drawStep3(graphics);
                this.drawStep4(graphics);
                this.drawStep5(graphics);
                this.drawStep6(graphics);
                this.drawStep8(graphics);
                this.drawStep7(graphics);
                break;
            }
        }
    }

    private void drawStep1(Graphics graphics) {
        this.drawFuzzyLine(graphics, this.leg1End[0], this.leg1End[1], this.gibbetFoot[0], this.gibbetFoot[1]);
    }

    private void drawStep2(Graphics graphics) {
        this.drawFuzzyLine(graphics, this.leg2End[0], this.leg2End[1], this.gibbetFoot[0], this.gibbetFoot[1]);
    }

    private void drawStep3(Graphics graphics) {
        this.drawFuzzyLine(graphics, this.gibbetFoot[0], this.gibbetFoot[1], this.gibbetTopLeft[0], this.gibbetTopLeft[1]);
    }

    private void drawStep4(Graphics graphics) {
        this.drawFuzzyLine(graphics, this.gibbetTopLeft[0], this.gibbetTopLeft[1], this.gibbetTopRight[0], this.gibbetTopRight[1]);
    }

    private void drawStep5(Graphics graphics) {
        this.drawFuzzyLine(graphics, this.gibbetTopLeft[0] + this.getWidth() / 4, this.gibbetTopLeft[1], this.gibbetTopLeft[0], this.gibbetTopLeft[1] + this.getHeight() / 4);
    }

    private void drawStep6(Graphics graphics) {
        this.drawFuzzyLine(graphics, this.gibbetTopRight[0], this.gibbetTopRight[1], this.head[0], this.head[1]);
    }

    private void drawStep7(Graphics graphics) {
        try {
            this.mediaTracker.waitForID(0);
            int n = this.headImage.getWidth(this);
            int n2 = this.headImage.getHeight(this);
            if (n < 0 || n2 < 0) {
                n = 131;
                n2 = 128;
            }
            int n3 = (int)(Math.random() * (double)this.variation * 2.0);
            graphics.drawImage(this.headImage, this.head[0] - n / 2 + n3 - this.variation, this.head[1] - n2 / 2, this);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void drawStep8(Graphics graphics) {
        try {
            this.mediaTracker.waitForID(1);
            this.mediaTracker.waitForID(0);
            int n = this.bodyImage.getWidth(this);
            int n2 = this.headImage.getHeight(this);
            if (n < 0 || n2 < 0) {
                n = 131;
                n2 = 128;
            }
            int n3 = (int)(Math.random() * (double)this.variation * 2.0);
            graphics.drawImage(this.bodyImage, this.head[0] - n / 2 + n3 - this.variation, this.head[1] - n2 / 2, this);
        }
        catch (InterruptedException interruptedException) {
            System.out.println("exception");
        }
    }

    private void drawFuzzyLine(Graphics graphics, int n, int n2, int n3, int n4) {
        for (int i = 0; i < this.numberOfFuzzyLines; ++i) {
            int n5 = this.variation / 2;
            int n6 = n + (int)(Math.random() * (double)this.variation) - n5;
            int n7 = n2 + (int)(Math.random() * (double)this.variation) - n5;
            int n8 = n3 + (int)(Math.random() * (double)this.variation) - n5;
            int n9 = n4 + (int)(Math.random() * (double)this.variation) - n5;
            graphics.drawLine(n6, n7, n8, n9);
        }
    }

    public int getNumberOfSteps() {
        return this.numberOfSteps;
    }
}

