/*
 * Decompiled with CFR 0.152.
 */
package ch.skybeam.mastermind.view;

import ch.skybeam.mastermind.view.PatternFilter;
import ch.skybeam.mastermind.view.PinVariationInterface;
import ch.skybeam.util.Globals;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JPanel;

public class ImageVariations {
    private static final String rcsHeader = "$Header: /data/cvs/hta/Mastermind/src/ch/skybeam/mastermind/view/ImageVariations.java,v 1.3 2004/01/25 21:51:33 rme Exp $";
    private static final String rcsName = "$Name: MASTERMIND_RELEASE_20040129 $";
    private static final String rcsRevision = "$Revision: 1.3 $";
    private static String imageDirectory = "image/pin";
    private static Pattern filePattern = Pattern.compile("^(.*)[\\d]+\\.(jpg|gif)");
    private static Vector imageVariations;

    public ImageVariation[] getImageVariations(String string) throws DirectoryNotFoundException {
        imageDirectory = string;
        return this.getImageVariations();
    }

    public ImageVariation[] getImageVariations() throws DirectoryNotFoundException {
        ImageVariation[] imageVariationArray;
        if (imageVariations == null) {
            imageVariationArray = this.getClass().getPackage().toString();
            String string = this.getClass().toString();
            string = string.substring(imageVariationArray.length() - 1);
            URL uRL = this.getClass().getResource(string + ".class");
            boolean bl = false;
            if (uRL.toString().startsWith("jar:")) {
                bl = true;
            }
            String[] stringArray = null;
            if (Globals.getDebugLevel() > 0) {
                System.out.println("Application base path: " + uRL);
                System.out.println("Application running from jar: " + bl);
                System.out.println("Image directory: " + imageDirectory);
            }
            if (!bl) {
                if (Globals.getDebugLevel() > 0) {
                    System.out.println("Application was started from directory: " + uRL);
                }
                try {
                    stringArray = this.getVariationsFromFS();
                }
                catch (DirectoryNotFoundException directoryNotFoundException) {
                    System.out.println(directoryNotFoundException.getMessage());
                }
            } else {
                if (Globals.getDebugLevel() > 0) {
                    System.out.println("Application was started from jar file: " + uRL);
                }
                stringArray = this.getVariationsFromJar(uRL);
            }
            imageVariations = new Vector();
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    imageVariations.add(stringArray[i]);
                }
            }
        }
        if (imageVariations.size() > 0) {
            imageVariationArray = new ImageVariation[imageVariations.size()];
            for (int i = 0; i < imageVariations.size(); ++i) {
                imageVariationArray[i] = new ImageVariation((String)imageVariations.get(i));
            }
            return imageVariationArray;
        }
        return null;
    }

    private String[] uniqueList(String[] stringArray) {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            Matcher matcher = filePattern.matcher(stringArray[i]);
            if (!matcher.matches()) continue;
            String string = matcher.group(1);
            boolean bl = true;
            Iterator iterator = vector.iterator();
            while (iterator.hasNext() && bl) {
                if (!((String)iterator.next()).equals(string)) continue;
                bl = false;
            }
            if (!bl) continue;
            if (Globals.getDebugLevel() > 0) {
                System.out.println("Adding variation: " + string);
            }
            vector.add(string);
        }
        String[] stringArray2 = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray2[i] = (String)vector.elementAt(i);
        }
        return stringArray2;
    }

    private String[] getVariationsFromFS() throws DirectoryNotFoundException {
        String[] stringArray;
        URL uRL = this.getClass().getResource(imageDirectory);
        File file = new File(uRL.getPath());
        String[] stringArray2 = null;
        if (Globals.getDebugLevel() > 0) {
            System.out.println("Path to image directory: " + uRL.getPath());
        }
        if (file.canRead()) {
            if (Globals.getDebugLevel() > 0) {
                System.out.println("readable!");
            }
            File[] fileArray = file.listFiles(new PatternFilter(filePattern));
            stringArray = new String[fileArray.length];
            for (int i = 0; i < fileArray.length; ++i) {
                stringArray[i] = fileArray[i].getName();
            }
        } else {
            throw new DirectoryNotFoundException("error reading directory " + file);
        }
        stringArray2 = this.uniqueList(stringArray);
        return stringArray2;
    }

    private String[] getVariationsFromJar(URL uRL) {
        String[] stringArray = null;
        try {
            JarURLConnection jarURLConnection = (JarURLConnection)uRL.openConnection();
            JarFile jarFile = jarURLConnection.getJarFile();
            String string = this.getClass().getPackage().getName().replace('.', '/') + "/" + imageDirectory;
            JarEntry jarEntry = jarFile.getJarEntry(string);
            if (jarEntry != null) {
                String[] stringArray2;
                if (Globals.getDebugLevel() > 0) {
                    System.out.println("Image directory found at: " + jarEntry.getName());
                }
                Enumeration<JarEntry> enumeration = jarFile.entries();
                Vector<String> vector = new Vector<String>();
                Vector<String[]> vector2 = new Vector<String[]>();
                while (enumeration.hasMoreElements()) {
                    stringArray2 = enumeration.nextElement();
                    if (stringArray2.isDirectory() || !stringArray2.getName().startsWith(string + "/")) continue;
                    if (Globals.getDebugLevel() > 0) {
                        System.out.println("Adding file to list: " + stringArray2.getName().substring(stringArray2.getName().lastIndexOf(47) + 1));
                    }
                    vector.add(stringArray2.getName().substring(stringArray2.getName().lastIndexOf(47) + 1));
                    vector2.add(stringArray2);
                }
                stringArray2 = new String[vector.size()];
                for (int i = 0; i < vector.size(); ++i) {
                    stringArray2[i] = (String)vector.get(i);
                }
                stringArray = this.uniqueList(stringArray2);
            } else if (Globals.getDebugLevel() > 0) {
                System.out.println("Image directory (" + imageDirectory + ") not found in jar file.");
            }
        }
        catch (IOException iOException) {
            System.err.println("IO exception: " + iOException);
        }
        return stringArray;
    }

    private class ImageVariation
    implements PinVariationInterface {
        private String imagePrefix;
        private Pattern variationPattern;
        private MediaTracker mediaTracker;
        private Image[] images;

        ImageVariation(String string) throws DirectoryNotFoundException {
            this.imagePrefix = string;
            this.variationPattern = Pattern.compile("^" + string + "[\\d]+\\.(jpg|gif)$");
            this.mediaTracker = new MediaTracker(new JPanel());
            String string2 = this.getClass().getPackage().toString();
            String string3 = this.getClass().toString();
            string3 = string3.substring(string2.length() - 1);
            URL uRL = this.getClass().getResource(string3 + ".class");
            boolean bl = false;
            if (uRL.toString().startsWith("jar:")) {
                bl = true;
            }
            File file = new File(uRL.getFile());
            if (!bl) {
                this.addImagesFS();
            } else {
                this.addImagesJar(uRL);
            }
            if (Globals.getDebugLevel() > 0) {
                System.out.println(this.getClass() + ": number of images: " + this.images.length);
            }
        }

        private void addImagesFS() throws DirectoryNotFoundException {
            URL uRL = this.getClass().getResource(imageDirectory);
            File file = new File(uRL.getPath());
            if (Globals.getDebugLevel() > 0) {
                System.out.println(this.getClass() + ": Filesystem, path: " + file);
            }
            if (file.isDirectory() && file.canRead()) {
                File[] fileArray = file.listFiles(new PatternFilter(this.variationPattern));
                if (Globals.getDebugLevel() > 0) {
                    System.out.println(this.getClass() + ": Filesystem, number of files: " + fileArray.length);
                }
                this.images = new Image[fileArray.length];
                for (int i = 0; i < fileArray.length; ++i) {
                    URL uRL2 = this.getClass().getResource(imageDirectory + "/" + fileArray[i].getName());
                    if (Globals.getDebugLevel() > 0) {
                        System.out.println("image added " + uRL2 + " index: " + i);
                    }
                    this.images[i] = Toolkit.getDefaultToolkit().getImage(uRL2);
                    this.mediaTracker.addImage(this.images[i], i);
                }
            } else {
                throw new DirectoryNotFoundException(uRL);
            }
        }

        private void addImagesJar(URL uRL) {
            try {
                JarURLConnection jarURLConnection = (JarURLConnection)uRL.openConnection();
                JarFile jarFile = jarURLConnection.getJarFile();
                String string = this.getClass().getPackage().getName().replace('.', '/') + "/" + imageDirectory;
                JarEntry jarEntry = jarFile.getJarEntry(string);
                if (jarEntry != null) {
                    String string2;
                    Enumeration<JarEntry> enumeration = jarFile.entries();
                    Vector<String> vector = new Vector<String>();
                    while (enumeration.hasMoreElements()) {
                        Matcher matcher;
                        JarEntry jarEntry2 = enumeration.nextElement();
                        if (jarEntry2.isDirectory() || !jarEntry2.getName().startsWith(string + "/")) continue;
                        string2 = jarEntry2.getName().substring(jarEntry2.getName().lastIndexOf(47) + 1);
                        if (Globals.getDebugLevel() > 0) {
                            System.out.println("Adding file to list: " + string2 + ".");
                        }
                        if (!(matcher = this.variationPattern.matcher(string2)).matches()) continue;
                        if (Globals.getDebugLevel() > 0) {
                            System.out.println(this.getClass() + ": found variation file: " + jarEntry2);
                        }
                        vector.add(string2);
                    }
                    this.images = new Image[vector.size()];
                    for (int i = 0; i < vector.size(); ++i) {
                        string2 = imageDirectory + "/" + vector.get(i).toString();
                        this.images[i] = Toolkit.getDefaultToolkit().getImage(this.getClass().getResource(string2));
                        this.mediaTracker.addImage(this.images[i], i);
                    }
                } else if (Globals.getDebugLevel() > 0) {
                    System.out.println("Image directory (" + imageDirectory + ") not found in jar file.");
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void drawPin(int n, Graphics graphics, int n2, int n3) {
            if (n > 0 && n <= this.images.length) {
                try {
                    if (Globals.getDebugLevel() > 0) {
                        System.out.println("waiting for image: " + n);
                    }
                    this.mediaTracker.waitForID(n - 1);
                }
                catch (InterruptedException interruptedException) {
                    System.out.println("image wait interrupted!\n");
                }
                int n4 = this.images[n - 1].getWidth(null);
                int n5 = this.images[n - 1].getHeight(null);
                int n6 = n2 - n4 / 2;
                int n7 = n3 - n5 / 2;
                graphics.drawImage(this.images[n - 1], n6, n7, n4, n5, null);
            }
        }

        public String getDescription() {
            return this.imagePrefix;
        }

        public int getNumberOfTypes() {
            return this.images.length;
        }
    }

    private class DirectoryNotFoundException
    extends FileNotFoundException {
        public DirectoryNotFoundException(URL uRL) {
            super("Directory '" + uRL.getPath() + "' could not be opened.");
        }

        public DirectoryNotFoundException(String string) {
            super(string);
        }
    }
}

