/*
 * Decompiled with CFR 0.152.
 */
package ch.skybeam.mastermind.view;

import ch.skybeam.mastermind.model.MatrixInterface;
import ch.skybeam.mastermind.model.Pin;
import ch.skybeam.mastermind.view.PinChangedEvent;
import ch.skybeam.mastermind.view.PinMatrixListener;
import ch.skybeam.mastermind.view.PinTypeConverter;
import ch.skybeam.mastermind.view.PinVariationInterface;
import ch.skybeam.util.Globals;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.MouseInputAdapter;

public class PinMatrix
extends JPanel {
    private static final String rcsHeader = "$Header: /data/cvs/hta/Mastermind/src/ch/skybeam/mastermind/view/PinMatrix.java,v 1.16 2004/01/29 18:35:56 rme Exp $";
    private static final String rcsName = "$Name: MASTERMIND_RELEASE_20040129 $";
    private static final String rcsRevision = "$Revision: 1.16 $";
    private Vector matrixChangeListeners = new Vector();
    private MatrixInterface matrix;
    private JPanel matrixPanel;
    private JPanel solutionPanel;
    private GuessWordPanel guessWordPanel;
    private JPanel selectedPinPanel;
    private Pin selectedPin = null;
    private PinVariationInterface pinDrawer;

    public PinMatrix(MatrixInterface matrixInterface, boolean bl, PinVariationInterface pinVariationInterface) {
        this.matrix = matrixInterface;
        this.pinDrawer = pinVariationInterface;
        this.setDoubleBuffered(true);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.guessWordPanel = new GuessWordPanel();
        this.guessWordPanel.setBorder(BorderFactory.createTitledBorder("L\u00f6sung:"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 4.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagLayout.addLayoutComponent(this.guessWordPanel, gridBagConstraints);
        this.add(this.guessWordPanel);
        this.matrixPanel = new MatrixPanel();
        this.matrixPanel.setBorder(BorderFactory.createTitledBorder("Spielfeld:"));
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.gridwidth = 4;
        gridBagConstraints2.gridheight = 8;
        gridBagConstraints2.weightx = 4.0;
        gridBagConstraints2.weighty = 8.0;
        gridBagConstraints2.fill = 1;
        gridBagLayout.addLayoutComponent(this.matrixPanel, gridBagConstraints2);
        this.add(this.matrixPanel);
        this.selectedPinPanel = new SelectedPinPanel();
        this.selectedPinPanel.setBorder(BorderFactory.createTitledBorder("Auswahl:"));
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 5;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.gridwidth = 1;
        gridBagConstraints3.gridheight = 1;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.weighty = 1.0;
        gridBagConstraints3.fill = 1;
        gridBagLayout.addLayoutComponent(this.selectedPinPanel, gridBagConstraints3);
        this.add(this.selectedPinPanel);
        this.solutionPanel = new SolutionPanel();
        this.solutionPanel.setBorder(BorderFactory.createTitledBorder("L\u00f6sung:"));
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 5;
        gridBagConstraints4.gridy = 1;
        gridBagConstraints4.gridwidth = 1;
        gridBagConstraints4.gridheight = 8;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.weighty = 8.0;
        gridBagConstraints4.fill = 1;
        gridBagLayout.addLayoutComponent(this.solutionPanel, gridBagConstraints4);
        this.add(this.solutionPanel);
    }

    public boolean addMatrixChangeListener(PinMatrixListener pinMatrixListener) {
        return this.matrixChangeListeners.add(pinMatrixListener);
    }

    private void createMatrixPanel() {
    }

    private void fireMatrixChangeEvent(PinChangedEvent pinChangedEvent) {
        Enumeration enumeration = this.matrixChangeListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((PinMatrixListener)enumeration.nextElement()).pinMatrixChanged(pinChangedEvent);
        }
    }

    public boolean removeMatrixChangeListener(PinMatrixListener pinMatrixListener) {
        return this.matrixChangeListeners.remove(pinMatrixListener);
    }

    public void setNewMatrix(MatrixInterface matrixInterface) {
        this.matrix = matrixInterface;
        this.repaint();
    }

    public void solved(Pin[] pinArray) {
        this.guessWordPanel.setGuessWord(pinArray);
    }

    public void setSelectedPin(Pin pin) {
        this.selectedPin = pin;
        this.selectedPinPanel.repaint();
    }

    public Pin getSelectedPin() {
        return this.selectedPin;
    }

    public PinVariationInterface getPinVariation() {
        return this.pinDrawer;
    }

    public void setPinVariation(PinVariationInterface pinVariationInterface) {
        this.pinDrawer = pinVariationInterface;
    }

    private class MatrixPanel
    extends JPanel {
        private int borderSize = 5;

        public MatrixPanel() {
            TitledBorder titledBorder = new TitledBorder("title");
            this.setBackground(Color.WHITE);
            this.setDoubleBuffered(true);
            this.addMouseListener(new MouseListener());
        }

        public void paint(Graphics graphics) {
            if (Globals.getDebugLevel() > 0) {
                System.out.println("Painting matrix panel");
            }
            super.paint(graphics);
            this.drawGrid(graphics);
            this.drawPins(graphics);
        }

        private void drawPins(Graphics graphics) {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            Border border = this.getBorder();
            if (border != null) {
                Insets insets = border.getBorderInsets(this);
                n = insets.left;
                n2 = insets.right;
                n3 = insets.top;
                n4 = insets.bottom;
            }
            int n5 = PinMatrix.this.matrix.getSizeY();
            int n6 = PinMatrix.this.matrix.getSizeX();
            int n7 = this.getWidth() - n - n2;
            int n8 = this.getHeight() - n3 - n4;
            float f = (float)n7 / (float)n6;
            float f2 = (float)n8 / (float)n5;
            for (int i = 0; i < n5; ++i) {
                for (int j = 0; j < n6; ++j) {
                    Pin pin = PinMatrix.this.matrix.getPin(j + 1, i + 1);
                    if (pin == null) continue;
                    PinMatrix.this.pinDrawer.drawPin(pin.getType(), graphics, (int)((double)((float)j * f) + (double)f / 2.0) + n, (int)((double)((float)i * f2) + (double)f2 / 2.0) + n3);
                }
            }
            Color color = new Color(0, 0, 0, 30);
            graphics.setColor(color);
            graphics.fillRect(n, n3, n7, (int)(f2 * (float)(PinMatrix.this.matrix.getCurrentRow() - 1)));
        }

        private void drawGrid(Graphics graphics) {
            int n;
            int n2;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            Border border = this.getBorder();
            if (border != null) {
                Insets insets = border.getBorderInsets(this);
                n3 = insets.left;
                n4 = insets.right;
                n5 = insets.top;
                n6 = insets.bottom;
            }
            int n7 = PinMatrix.this.matrix.getSizeY();
            int n8 = PinMatrix.this.matrix.getSizeX();
            int n9 = this.getWidth() - n3 - n4;
            int n10 = this.getHeight() - n5 - n6;
            float f = (float)n9 / (float)n8;
            float f2 = (float)n10 / (float)n7;
            Color color = graphics.getColor();
            Color color2 = new Color(240, 240, 240);
            graphics.setColor(color2);
            graphics.fillRect(n3, (int)(f2 * (float)(PinMatrix.this.matrix.getCurrentRow() - 1)) + n5, n9, (int)f2);
            graphics.setColor(Color.BLACK);
            for (n2 = 0; n2 <= n7; ++n2) {
                n = (int)(f2 * (float)n2) + n5;
                graphics.drawLine(n3, n, n9 + n3, n);
            }
            for (n2 = 0; n2 <= n8; ++n2) {
                n = (int)(f * (float)n2) + n3;
                graphics.drawLine(n, n5, n, n10 + n5);
            }
            graphics.setColor(color);
        }

        private class MouseListener
        extends MouseInputAdapter {
            private MouseListener() {
            }

            public void mousePressed(MouseEvent mouseEvent) {
                JPanel jPanel = (JPanel)mouseEvent.getComponent();
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                Border border = jPanel.getBorder();
                if (border != null) {
                    Insets insets = border.getBorderInsets((JPanel)mouseEvent.getSource());
                    n = insets.left;
                    n2 = insets.right;
                    n3 = insets.top;
                    n4 = insets.bottom;
                }
                if (PinMatrix.this.selectedPin != null && mouseEvent.getX() > n && mouseEvent.getX() < jPanel.getWidth() - n2 && mouseEvent.getY() > n3 && mouseEvent.getY() < jPanel.getHeight() - n4) {
                    int n5 = PinMatrix.this.matrix.getSizeY();
                    int n6 = PinMatrix.this.matrix.getSizeX();
                    float f = (float)(jPanel.getHeight() - n3 - n4) / (float)n5;
                    float f2 = (float)(jPanel.getWidth() - n - n2) / (float)n6;
                    int n7 = (int)((float)(mouseEvent.getX() - n) / f2);
                    int n8 = (int)((float)(mouseEvent.getY() - n3) / f);
                    PinChangedEvent pinChangedEvent = new PinChangedEvent(n7 + 1, n8 + 1, PinMatrix.this.selectedPin);
                    PinMatrix.this.fireMatrixChangeEvent(pinChangedEvent);
                }
            }
        }
    }

    private class GuessWordPanel
    extends JPanel {
        private Pin[] guessWord;

        public GuessWordPanel() {
            this.setBackground(Color.WHITE);
            this.setDoubleBuffered(true);
        }

        public void paint(Graphics graphics) {
            int n;
            super.paint(graphics);
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            Border border = this.getBorder();
            if (border != null) {
                Insets insets = border.getBorderInsets(this);
                n2 = insets.left;
                n3 = insets.right;
                n4 = insets.top;
                n5 = insets.bottom;
            }
            int n6 = PinMatrix.this.matrix.getSizeX();
            int n7 = this.getWidth() - n2 - n3;
            int n8 = this.getHeight() - n4 - n5;
            float f = (float)n7 / (float)n6;
            float f2 = f / 2.0f;
            float f3 = (float)n8 / 2.0f;
            Color color = graphics.getColor();
            graphics.setColor(Color.BLACK);
            graphics.drawRect(n2, n4, n7, n8);
            for (n = 1; n < n6; ++n) {
                int n9 = (int)(f * (float)n) + n2;
                graphics.drawLine(n9, n4, n9, n8 + n4);
            }
            for (n = 0; n < n6; ++n) {
                if (this.guessWord != null && this.guessWord.length > n && this.guessWord[n] != null) {
                    PinMatrix.this.pinDrawer.drawPin(this.guessWord[n].getType(), graphics, (int)((float)n * f + f2) + n2, (int)f3 + n4);
                    continue;
                }
                graphics.drawString("?", (int)((float)n * f + f2) + n2, (int)f3 + n4);
            }
            graphics.setColor(color);
        }

        public void setGuessWord(Pin[] pinArray) {
            this.guessWord = pinArray;
            this.repaint();
        }
    }

    private class SolutionPanel
    extends JPanel {
        PinTypeConverter converter = new PinTypeConverter();

        public SolutionPanel() {
            this.setBackground(Color.WHITE);
            this.setDoubleBuffered(true);
        }

        public void paint(Graphics graphics) {
            int n;
            int n2;
            super.paint(graphics);
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            Border border = this.getBorder();
            if (border != null) {
                Insets insets = border.getBorderInsets(this);
                n3 = insets.left;
                n4 = insets.right;
                n5 = insets.top;
                n6 = insets.bottom;
            }
            int n7 = PinMatrix.this.matrix.getSizeY();
            int n8 = PinMatrix.this.matrix.getSizeX();
            int n9 = this.getHeight() - n5 - n6;
            int n10 = this.getWidth() - n3 - n4;
            float f = (float)n9 / (float)n7;
            float f2 = (float)n10 / (float)n8;
            int n11 = 2;
            float f3 = (float)PinMatrix.this.matrix.getSizeX() / (float)n11;
            int n12 = f3 % 1.0f > 0.0f ? (int)f3 + 1 : (int)f3;
            int n13 = n10 / n12;
            int n14 = (int)(f / (float)n11);
            Color color = graphics.getColor();
            graphics.setColor(Color.BLACK);
            graphics.drawRect(n3, n5, n10, n9);
            for (n2 = 1; n2 < n7; ++n2) {
                n = (int)(f * (float)n2) + n5;
                graphics.drawLine(n3, n, n10 + n3, n);
            }
            for (n2 = 0; n2 < n7; ++n2) {
                int n15;
                int n16;
                int n17;
                n = (int)(f * (float)n2) + n5;
                if (PinMatrix.this.matrix.getCorrectionOrder()) {
                    for (n17 = 0; n17 < n8; ++n17) {
                        n16 = (int)(f2 * (float)n17) + n3;
                        Pin pin = PinMatrix.this.matrix.getPin(n17 + 1, n2 + 1);
                        n15 = 1;
                        if (pin != null) {
                            n15 = pin.getStatus();
                        }
                        if (n15 == 0) {
                            n15 = 1;
                        }
                        this.converter.drawSolutionPin(n15, graphics, (int)((float)n16 + f2 / 2.0f), (int)((float)n + f / 2.0f));
                    }
                    continue;
                }
                n17 = PinMatrix.this.matrix.getCorrectPins(n2 + 1);
                n16 = PinMatrix.this.matrix.getWrongPositionPins(n2 + 1);
                for (int i = 0; i < n11; ++i) {
                    for (n15 = 0; n15 < n12; ++n15) {
                        int n18 = n15 * n13 + n13 / 2 + n3;
                        int n19 = n + n14 * i + n14 / 2;
                        if (n17 > 0) {
                            this.converter.drawSolutionPin(3, graphics, n18, n19);
                            --n17;
                            continue;
                        }
                        if (n16 > 0) {
                            this.converter.drawSolutionPin(2, graphics, n18, n19);
                            --n16;
                            continue;
                        }
                        this.converter.drawSolutionPin(1, graphics, n18, n19);
                    }
                }
            }
            graphics.setColor(color);
        }
    }

    private class SelectedPinPanel
    extends JPanel {
        public SelectedPinPanel() {
            this.setBackground(Color.WHITE);
            this.setDoubleBuffered(true);
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            Border border = this.getBorder();
            if (border != null) {
                Insets insets = border.getBorderInsets(this);
                n = insets.left;
                n2 = insets.right;
                n3 = insets.top;
                n4 = insets.bottom;
            }
            int n5 = (this.getWidth() - n - n2) / 2 + n;
            int n6 = (this.getHeight() - n3 - n4) / 2 + n3;
            if (PinMatrix.this.selectedPin != null) {
                PinMatrix.this.pinDrawer.drawPin(PinMatrix.this.selectedPin.getType(), graphics, n5, n6);
            }
        }
    }
}

