/*
 * Decompiled with CFR 0.152.
 */
package ch.skybeam.mastermind.view;

import ch.skybeam.mastermind.view.ColorVariation;
import ch.skybeam.mastermind.view.ImageVariations;
import ch.skybeam.mastermind.view.PinVariationInterface;
import ch.skybeam.util.Globals;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.io.FileNotFoundException;
import java.net.URL;
import java.util.Vector;
import javax.swing.JPanel;

public class PinTypeConverter
implements PinVariationInterface {
    private static final String rcsHeader = "$Header: /data/cvs/hta/Mastermind/src/ch/skybeam/mastermind/view/PinTypeConverter.java,v 1.7 2004/01/25 23:07:57 rme Exp $";
    private static final String rcsName = "$Name: MASTERMIND_RELEASE_20040129 $";
    private static final String rcsRevision = "$Revision: 1.7 $";
    private static Vector variations = new Vector();
    private static int currentVariation = 0;
    private static MediaTracker mediaTracker = new MediaTracker(new JPanel());
    private static String[] correctionPinPaths = new String[]{"image/empty.gif", "image/wrongPosition.gif", "image/correctPosition.gif"};
    private static Image[] correctionPins = new Image[correctionPinPaths.length];
    static /* synthetic */ Class class$ch$skybeam$mastermind$view$PinMatrix;

    public PinTypeConverter() {
        block9: {
            if (variations == null || variations.size() < 1) {
                Object object;
                for (int i = 0; i < correctionPinPaths.length; ++i) {
                    object = (class$ch$skybeam$mastermind$view$PinMatrix == null ? PinTypeConverter.class$("ch.skybeam.mastermind.view.PinMatrix") : class$ch$skybeam$mastermind$view$PinMatrix).getResource(correctionPinPaths[i]);
                    if (object == null) continue;
                    PinTypeConverter.correctionPins[i] = Toolkit.getDefaultToolkit().getImage((URL)object);
                    mediaTracker.addImage(correctionPins[i], i);
                }
                ColorVariation colorVariation = new ColorVariation();
                variations.add(colorVariation);
                try {
                    object = new ImageVariations();
                    ImageVariations.ImageVariation[] imageVariationArray = ((ImageVariations)object).getImageVariations();
                    if (imageVariationArray == null) {
                        if (Globals.getDebugLevel() > 0) {
                            System.err.println("Warning: no image variations available!");
                        }
                    } else {
                        for (int i = 0; i < imageVariationArray.length; ++i) {
                            variations.add(imageVariationArray[i]);
                        }
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    if (Globals.getDebugLevel() <= 0) break block9;
                    System.out.println("Image variation, file not found: " + fileNotFoundException);
                }
            }
        }
        if (Globals.getDebugLevel() > 0) {
            System.out.println(this.getClass() + ": number of variations: " + variations.size());
        }
    }

    public void setVariation(int n) throws IllegalArgumentException {
        if (n <= 0 || n > variations.size()) {
            throw new IllegalPinVariation(n);
        }
        currentVariation = n - 1;
    }

    public int getNumberOfVariations() {
        return variations.size();
    }

    public PinVariationInterface[] getVariations() {
        return (PinVariationInterface[])variations.toArray();
    }

    public void drawPin(int n, Graphics graphics, int n2, int n3) {
        ((PinVariationInterface)variations.get(currentVariation)).drawPin(n, graphics, n2, n3);
    }

    public void drawPin(int n, int n2, Graphics graphics, int n3, int n4) throws IllegalArgumentException {
        if (n <= 0 || n > variations.size()) {
            throw new IllegalPinVariation(n);
        }
        ((PinVariationInterface)variations.get(n - 1)).drawPin(n2, graphics, n3, n4);
    }

    public String getDescription() {
        return ((PinVariationInterface)variations.get(currentVariation)).getDescription();
    }

    public String getDescription(int n) {
        String string = "";
        if (n <= 0 || n > this.getNumberOfVariations()) {
            throw new IllegalPinVariation(n);
        }
        string = ((PinVariationInterface)variations.get(n - 1)).getDescription();
        return string;
    }

    public int getNumberOfTypes() {
        return ((PinVariationInterface)variations.get(currentVariation)).getNumberOfTypes();
    }

    public int getNumberOfTypes(int n) {
        int n2 = 0;
        if (n <= 0 || n > this.getNumberOfVariations()) {
            throw new IllegalPinVariation(n);
        }
        n2 = ((PinVariationInterface)variations.get(n - 1)).getNumberOfTypes();
        return n2;
    }

    public void drawSolutionPin(int n, Graphics graphics, int n2, int n3) throws IllegalArgumentException {
        if (n >= 1 && n <= 3) {
            try {
                if (Globals.getDebugLevel() > 0) {
                    System.out.println("waiting for image: " + n);
                }
                mediaTracker.waitForID(n - 1);
                int n4 = correctionPins[n - 1].getWidth(null);
                int n5 = correctionPins[n - 1].getHeight(null);
                int n6 = n2 - n4 / 2;
                int n7 = n3 - n5 / 2;
                graphics.drawImage(correctionPins[n - 1], n6, n7, n4, n5, null);
            }
            catch (Exception exception) {
                System.err.println("Error drawing images - using fallback solution!\n");
                int n8 = 10;
                int n9 = n2 - n8 / 2;
                int n10 = n3 - n8 / 2;
                Color color = graphics.getColor();
                switch (n) {
                    case 2: {
                        graphics.setColor(Color.RED);
                        graphics.fillOval(n9, n10, n8, n8);
                        break;
                    }
                    case 1: {
                        graphics.setColor(Color.GREEN);
                        graphics.fillOval(n9, n10, n8, n8);
                        break;
                    }
                    default: {
                        graphics.setColor(Color.BLACK);
                        graphics.drawOval(n9, n10, n8, n8);
                    }
                }
                graphics.setColor(color);
            }
        } else {
            throw new IllegalArgumentException("Pin type (" + n + ") out of range, should be: 1 <= pinType <= 3");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class IllegalPinVariation
    extends IllegalArgumentException {
        public IllegalPinVariation(int n) {
            super("Pin variation (" + n + ")" + " out of range.\nAllowed range: 0 < pinVariation < " + variations.size());
        }

        public IllegalPinVariation(String string) {
            super(string);
        }
    }
}

