/*
 * Decompiled with CFR 0.152.
 */
package ch.skybeam.mastermind.view;

import ch.skybeam.mastermind.model.Pin;
import ch.skybeam.mastermind.view.PinVariationInterface;
import ch.skybeam.mastermind.view.SelectorPanelListenerInterface;
import ch.skybeam.util.Globals;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.event.MouseInputAdapter;

public class SelectorPanel
extends JPanel {
    private static final String rcsHeader = "$Header: /data/cvs/hta/Mastermind/src/ch/skybeam/mastermind/view/SelectorPanel.java,v 1.5 2004/01/23 18:15:27 rme Exp $";
    private static final String rcsName = "$Name: MASTERMIND_RELEASE_20040129 $";
    private static final String rcsRevision = "$Revision: 1.5 $";
    private int numberOfPinTypes = 0;
    private Vector pinClickListeners = new Vector();
    private PinVariationInterface pinDrawer;
    private int numberOfRows = 2;
    private PinPanel[] pinPanels;

    private void firePinClickAction(Pin pin) {
        Enumeration enumeration = this.pinClickListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((SelectorPanelListenerInterface)enumeration.nextElement()).setSelectedPin(pin);
        }
    }

    public SelectorPanel(int n, PinVariationInterface pinVariationInterface) throws IllegalArgumentException {
        if (pinVariationInterface == null) {
            throw new IllegalArgumentException("Error: invalid pin drawer (null)!");
        }
        if (n < 1 || n > pinVariationInterface.getNumberOfTypes()) {
            throw new IllegalArgumentException("Error: illegal number of pin types (" + n + ")\n" + "Valid range: 0 < numberOfPinTypes <= " + pinVariationInterface.getNumberOfTypes());
        }
        this.numberOfPinTypes = n;
        this.pinDrawer = pinVariationInterface;
        this.setBorder(BorderFactory.createTitledBorder("Pin Auswahl:"));
        this.setBackground(Color.WHITE);
        this.createPinPanels();
    }

    public boolean addPinClickListeners(SelectorPanelListenerInterface selectorPanelListenerInterface) {
        return this.pinClickListeners.add(selectorPanelListenerInterface);
    }

    public boolean removePinClickListeners(SelectorPanelListenerInterface selectorPanelListenerInterface) {
        return this.pinClickListeners.remove(selectorPanelListenerInterface);
    }

    private void createPinPanels() {
        this.removeAll();
        float f = (float)this.numberOfPinTypes / (float)this.numberOfRows;
        int n = f % 1.0f > 0.0f ? (int)f + 1 : (int)f;
        this.setLayout(new GridLayout(this.numberOfRows, n));
        for (int i = 0; i < this.numberOfPinTypes; ++i) {
            PinPanel pinPanel = new PinPanel(new Pin(i + 1));
            this.add(pinPanel);
        }
    }

    public void setNumberOfPinTypes(int n) {
        if (n != this.numberOfPinTypes) {
            this.numberOfPinTypes = n;
            this.createPinPanels();
        }
    }

    public PinVariationInterface getPinVariation() {
        return this.pinDrawer;
    }

    public void setPinVariation(PinVariationInterface pinVariationInterface) {
        this.pinDrawer = pinVariationInterface;
        this.repaint();
    }

    private class PinPanel
    extends JPanel {
        private Pin pin;

        public PinPanel(Pin pin) {
            this.pin = pin;
            this.setBackground(Color.WHITE);
            this.addMouseListener(new MouseMotionListener());
        }

        public void paint(Graphics graphics) {
            if (Globals.getDebugLevel() > 0) {
                System.out.println("paint selector panel");
            }
            super.paint(graphics);
            int n = this.pin.getType();
            SelectorPanel.this.pinDrawer.drawPin(n, graphics, this.getWidth() / 2, this.getHeight() / 2);
        }

        private class MouseMotionListener
        extends MouseInputAdapter {
            private MouseMotionListener() {
            }

            public void mousePressed(MouseEvent mouseEvent) {
                SelectorPanel.this.firePinClickAction(PinPanel.this.pin);
            }
        }
    }
}

